/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.agent.install.ssh;

import com.urbancode.air.agent.install.ssh.AgentInstallProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class AgentInstallPropertiesWriter {
    public void writeToPropertiesFile(AgentInstallProperties installProps, File file) throws IOException {
        file.getParentFile().mkdirs();
        Properties outputProps = new Properties();
        this.setProperty(outputProps, "locked/agent.name", installProps.getAgentName());
        this.setProperty(outputProps, "install.agent.dir", installProps.getInstallDir());
        this.setProperty(outputProps, "IBM UrbanCode Deploy/java.home", installProps.getJavaHome());
        this.setProperty(outputProps, "agentcomm.server.uri", installProps.getAgentCommServerUri());
        this.setProperty(outputProps, "agentcomm.proxy.uri", installProps.getAgentCommProxyUri());
        if (installProps.isAgentCommEnabled()) {
            this.setProperty(outputProps, "agentcomm.enabled", "true");
        }
        if (installProps.getAgentId() != null) {
            this.setProperty(outputProps, "locked/agent.id", installProps.getAgentId());
        }
        for (Map.Entry<String, String> ent : installProps.getProperties().entrySet()) {
            this.setProperty(outputProps, ent.getKey(), ent.getValue());
        }
        outputProps.store(new FileOutputStream(file), null);
    }

    private void setProperty(Properties props, String key, Integer value) {
        props.setProperty(key, value == null ? "" : String.valueOf(value));
    }

    private void setProperty(Properties props, String key, String value) {
        props.setProperty(key, value == null ? "" : value);
    }
}

