/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.agent.install.ssh;

import com.urbancode.air.agent.install.ssh.AgentInstallProperties;
import com.urbancode.air.agent.install.ssh.AgentInstallPropertiesWriter;
import com.urbancode.air.agent.install.ssh.OpenHostKeyVerifier;
import com.urbancode.air.agent.install.ssh.SshAgentInstallConfig;
import com.urbancode.air.agent.install.ssh.SshCredentials;
import com.urbancode.air.agent.install.ssh.SshHost;
import com.urbancode.air.agent.install.ssh.StringJoiner;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import org.apache.log4j.Logger;

public class SshAgentInstaller {
    private static final Logger log = Logger.getLogger(SshAgentInstaller.class);
    private static final String INSTALL_CLASS_NAME = "com.urbancode.agent.upgrade.Stage1Install";
    private final File agentUpgradeFile;
    private File agentInstallOutputFile;

    public SshAgentInstaller(File agentUpgradeFile) {
        this.agentUpgradeFile = agentUpgradeFile;
        this.agentInstallOutputFile = new File("../var/log/agent-install.out");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(SSHClient sshClient, SshAgentInstallConfig config, AgentInstallProperties installProps) throws IOException {
        this.enableCompressionIfPossible(sshClient);
        this.connectToHost(sshClient, config.getHost());
        try {
            this.authenticate(sshClient, config.getCredentials());
            String resolvedJavaHome = this.resolveJavaHome(sshClient, config.getJavaHomePath());
            this.checkJavaHome(sshClient, resolvedJavaHome);
            installProps.setJavaHome(resolvedJavaHome);
            File installPropsFile = this.writeInstallPropertiesToFile(installProps);
            try {
                this.uploadFiles(sshClient, config, installPropsFile);
            }
            finally {
                installPropsFile.delete();
            }
            this.installAgent(sshClient, resolvedJavaHome, config.getTempDirPath());
            this.startAgent(sshClient, installProps.getInstallDir());
        }
        finally {
            sshClient.disconnect();
        }
    }

    private File writeInstallPropertiesToFile(AgentInstallProperties installProps) throws IOException {
        File installPropsFile = File.createTempFile("install", "properties");
        AgentInstallPropertiesWriter installPropsWriter = new AgentInstallPropertiesWriter();
        installPropsWriter.writeToPropertiesFile(installProps, installPropsFile);
        return installPropsFile;
    }

    private void connectToHost(SSHClient sshClient, SshHost host) throws IOException {
        try {
            sshClient.loadKnownHosts();
        }
        catch (IOException e) {
            log.debug((Object)"Could not load known_hosts file from the default locations", (Throwable)e);
        }
        sshClient.addHostKeyVerifier((HostKeyVerifier)new OpenHostKeyVerifier());
        try {
            sshClient.connect(host.getHostname(), host.getPort());
        }
        catch (IOException e) {
            throw new IOException("Could not connect to host: " + e.getMessage(), e);
        }
    }

    private void enableCompressionIfPossible(SSHClient sshClient) throws IOException {
        try {
            Class.forName("com.jcraft.jzlib.ZStream");
            sshClient.useCompression();
            log.debug((Object)"Using zlib compression on scp");
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)"Not using zlib compression on scp");
        }
    }

    private void authenticate(SSHClient sshClient, SshCredentials credentials) throws IOException {
        if (credentials.getAuthType().equals((Object)SshCredentials.AuthenticationType.PUBLICKEY)) {
            sshClient.authPublickey(credentials.getUsername());
        } else {
            sshClient.authPassword(credentials.getUsername(), credentials.getPassword());
        }
    }

    private void uploadFiles(SSHClient sshClient, SshAgentInstallConfig config, File installPropsFile) throws IOException {
        StringJoiner remoteUpdateJarPath = new StringJoiner("/");
        remoteUpdateJarPath.append(config.getTempDirPath()).append(this.agentUpgradeFile.getName());
        this.checkTmpDir(sshClient, config.getTempDirPath());
        this.uploadFile(sshClient, this.agentUpgradeFile, remoteUpdateJarPath.toString());
        StringJoiner remoteInstallPropsPath = new StringJoiner("/");
        remoteInstallPropsPath.append(config.getTempDirPath()).append("install.properties");
        this.uploadFile(sshClient, installPropsFile, remoteInstallPropsPath.toString());
    }

    private void uploadFile(SSHClient sshClient, File file, String remotePath) throws IOException {
        log.info((Object)("Transferring " + file + " (" + file.length() + " bytes) ..."));
        long transferStart = System.currentTimeMillis();
        sshClient.newSCPFileTransfer().upload(file.getAbsolutePath(), remotePath);
        long transferTime = System.currentTimeMillis() - transferStart;
        log.info((Object)("Transfer of " + file + " complete in " + transferTime + " ms."));
    }

    private int executeCommand(SSHClient sshClient, String cmdLine) throws IOException {
        OutputStream out = null;
        return this.executeCommand(sshClient, cmdLine, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeCommand(SSHClient sshClient, String cmdLine, File outputFile) throws IOException {
        if (outputFile != null && !outputFile.exists()) {
            outputFile.createNewFile();
        }
        OutputStream out = null;
        if (outputFile != null) {
            out = new FileOutputStream(outputFile, true);
        }
        try {
            int n = this.executeCommand(sshClient, cmdLine, out);
            return n;
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeCommand(SSHClient sshClient, String cmdLine, OutputStream out) throws IOException {
        Session session = sshClient.startSession();
        try {
            log.debug((Object)("ssh exec: " + cmdLine));
            Session.Command cmd = session.exec(cmdLine);
            ByteArrayOutputStream cmdOutputStream = IOUtils.readFully((InputStream)cmd.getInputStream());
            ByteArrayOutputStream errOuptutStream = IOUtils.readFully((InputStream)cmd.getErrorStream());
            if (out != null) {
                byte[] stdOutByteArray = cmdOutputStream.toByteArray();
                byte[] stdErrByteArray = errOuptutStream.toByteArray();
                out.write(stdOutByteArray);
                out.write("\n".getBytes());
                out.write(stdErrByteArray);
            }
            cmd.join();
            log.debug((Object)("exit code: " + cmd.getExitStatus()));
            int n = cmd.getExitStatus();
            return n;
        }
        finally {
            session.close();
        }
    }

    private void installAgent(SSHClient sshClient, String javaHomePath, String tempDirPath) throws IOException {
        log.info((Object)"Installing agent...");
        String cmd = this.getInstallAgentCommand(javaHomePath, tempDirPath);
        int installResult = this.executeCommand(sshClient, cmd, this.agentInstallOutputFile);
        if (installResult != 0) {
            throw new IOException("Installing the agent failed with return code " + installResult + " from the SSH Client. See agent-install.out, located in ./var/log for details");
        }
        log.info((Object)"Installed agent");
    }

    private String getInstallAgentCommand(String javaHomePath, String tempDirPath) {
        StringJoiner javaPath = new StringJoiner("/");
        javaPath.append(javaHomePath).append("bin/java");
        StringJoiner remoteJarPath = new StringJoiner("/");
        remoteJarPath.append(tempDirPath).append(this.agentUpgradeFile.getName());
        StringJoiner remotePropsPath = new StringJoiner("/");
        remotePropsPath.append(tempDirPath).append("install.properties");
        StringBuilder builder = new StringBuilder();
        builder.append("cd ").append(tempDirPath).append(";");
        builder.append(javaPath).append(" -cp ").append(remoteJarPath);
        builder.append(" ").append(INSTALL_CLASS_NAME).append(" ").append(remoteJarPath);
        builder.append(" ").append(remotePropsPath);
        String cmdLine = builder.toString();
        return cmdLine;
    }

    private String resolveJavaHome(SSHClient sshClient, String javaHomePath) throws IOException {
        if ("".equals(javaHomePath) || "$JAVA_HOME".equals(javaHomePath)) {
            String cmd = "echo $JAVA_HOME";
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int checkResult = this.executeCommand(sshClient, cmd, output);
            if (checkResult != 0) {
                throw new IOException("Error getting JAVA_HOME from target.");
            }
            javaHomePath = output.toString().split("\n", 2)[0];
        }
        return javaHomePath;
    }

    private void checkJavaHome(SSHClient sshClient, String javaHomePath) throws IOException {
        String cmd = this.getCheckJavaHomeCommand(javaHomePath);
        int checkResult = this.executeCommand(sshClient, cmd);
        if (checkResult != 0) {
            throw new IOException("Invalid Java Home path. SSH Client returned error code " + checkResult + " upon attempt to run Java");
        }
    }

    private String getCheckJavaHomeCommand(String javaHomePath) {
        StringJoiner javaPath = new StringJoiner("/");
        javaPath.append(javaHomePath).append("bin/java");
        String cmdLine = javaPath + " -version";
        return cmdLine;
    }

    private void checkTmpDir(SSHClient sshClient, String tmpDirPath) throws IOException {
        StringJoiner tmpPath = new StringJoiner("/");
        tmpPath.append(tmpDirPath);
        String cmdLine = "mkdir -p " + tmpPath;
        int checkResult = this.executeCommand(sshClient, cmdLine);
        if (checkResult != 0) {
            throw new IOException("Could not create tmp directory.  SSH Client returned error code " + checkResult + " upon attempt to make directory");
        }
    }

    private void startAgent(SSHClient sshClient, String agentPath) throws IOException {
        log.info((Object)"Starting agent...");
        int startResult = this.executeCommand(sshClient, this.getStartAgentCommand(agentPath));
        if (startResult != 0) {
            throw new IOException("Starting the agent failed with return code " + startResult);
        }
        log.info((Object)"Started agent");
    }

    private String getStartAgentCommand(String agentPath) {
        StringJoiner agentScriptPath = new StringJoiner("/");
        agentScriptPath.append(agentPath).append("bin/agent");
        String cmdLine = agentScriptPath + " start";
        return cmdLine;
    }
}

