/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ud.client;

import com.urbancode.commons.util.IO;
import com.urbancode.ud.client.UDRestClient;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.impl.client.DefaultHttpClient;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class AgentClient
extends UDRestClient {
    public AgentClient(URI url, String clientUser, String clientPassword) {
        super(url, clientUser, clientPassword);
    }

    public AgentClient(URI url, String clientUser, String clientPassword, boolean trustAllCerts) {
        super(url, clientUser, clientPassword, trustAllCerts);
    }

    public AgentClient(URI url, DefaultHttpClient client) {
        super(url, client);
    }

    public void deleteAgent(String name) throws IOException {
        String uri = this.url + "/cli/agentCLI";
        uri = uri + "?agent=" + this.encodePath(name);
        HttpDelete method = new HttpDelete(uri);
        this.invokeMethod(method);
    }

    public int getAgentInstallPackage(File agentZipLocation) throws IOException {
        int result = 1;
        String uri = this.url + "/tools/ibm-ucd-agent.zip";
        HttpGet method = new HttpGet(uri);
        HttpResponse resp = this.invokeMethod(method);
        IO.copy(resp.getEntity().getContent(), agentZipLocation);
        return result;
    }

    public String getAgentProperty(String agentName, String name) throws IOException {
        String result = null;
        if ("".equals(agentName) || "".equals(name)) {
            throw new IOException("a required argument was not supplied");
        }
        String uri = this.url + "/cli/agentCLI/getProperty?agent=" + this.encodePath(agentName) + "&name=" + this.encodePath(name);
        HttpGet method = new HttpGet(uri);
        HttpResponse response = this.invokeMethod(method);
        result = this.getBody(response);
        return result;
    }

    public void installAgent(String name, String host, String port, String sshUsername, String sshPassword, String installDir, String javaHomePath, String tempDirPath, String serverHost, String serverPort, String proxyPort, String mutualAuth) throws IOException {
        this.installAgent(name, host, port, sshUsername, sshPassword, installDir, javaHomePath, tempDirPath, serverHost, serverPort, "", proxyPort, mutualAuth);
    }

    @Deprecated
    public void installAgent(String name, String host, String port, String sshUsername, String sshPassword, String installDir, String javaHomePath, String tempDirPath, String serverHost, String serverPort, String proxyHost, String proxyPort, String mutualAuth) throws IOException {
        String uri = this.url + "/cli/sshInstallAgent/installNewAgent" + "?name=" + this.encodePath(name) + "&host=" + this.encodePath(host) + "&port=" + this.encodePath(port) + "&sshUsername=" + this.encodePath(sshUsername) + "&sshPassword=" + this.encodePath(sshPassword) + "&sshPassword=" + this.encodePath(sshPassword) + "&installDir=" + this.encodePath(installDir) + "&javaHomePath=" + this.encodePath(javaHomePath) + "&tempDirPath=" + this.encodePath(tempDirPath) + "&serverHost=" + this.encodePath(serverHost) + "&serverPort=" + this.encodePath(serverPort) + "&proxyHost=" + this.encodePath(proxyHost) + "&proxyPort=" + this.encodePath(proxyPort) + "&mutualAuth=" + this.encodePath(mutualAuth);
        HttpPut method = new HttpPut(uri);
        this.invokeMethod(method);
    }

    public String setAgentProperty(String agentName, String name, String value, boolean isSecure) throws IOException {
        if ("".equals(agentName) || "".equals(name)) {
            throw new IOException("a required argument was not supplied");
        }
        String uri = this.url + "/cli/agentCLI/setProperty?agent=" + this.encodePath(agentName) + "&name=" + this.encodePath(name) + "&value=" + this.encodePath(value) + "&isSecure=" + this.encodePath(String.valueOf(isSecure));
        HttpPut method = new HttpPut(uri);
        this.invokeMethod(method);
        String result = isSecure ? name + "=****" : name + "=" + value;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getAgent(String agentName) throws IOException, JSONException {
        JSONObject result = null;
        String uri = this.url + "/cli/agentCLI/info";
        uri = uri + "?agent=" + this.encodePath(agentName);
        HttpGet method = new HttpGet(uri);
        try {
            HttpResponse response = this.invokeMethod(method);
            String body = this.getBody(response);
            result = new JSONObject(body);
        }
        finally {
            this.releaseConnection(method);
        }
        return result;
    }
}

