/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.agent.install.ssh;

import com.urbancode.air.agent.install.ssh.AgentInstallProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class AgentInstallPropertiesWriter {
    public void writeToPropertiesFile(AgentInstallProperties installProps, File file) throws IOException {
        file.getParentFile().mkdirs();
        Properties outputProps = new Properties();
        this.setProperty(outputProps, "locked/agent.name", installProps.getAgentName());
        this.setProperty(outputProps, "install.agent.dir", installProps.getInstallDir());
        this.setProperty(outputProps, "IBM UrbanCode Deploy/java.home", installProps.getJavaHome());
        this.setProperty(outputProps, "locked/agent.mutual_auth", String.valueOf(installProps.isUsingMutualAuth()));
        this.setProperty(outputProps, "locked/agent.http.proxy.host", installProps.getProxyHost());
        this.setProperty(outputProps, "locked/agent.http.proxy.port", installProps.getProxyPort());
        this.setProperty(outputProps, "locked/agent.jms.remote.host", installProps.getJmsHost());
        this.setProperty(outputProps, "locked/agent.jms.remote.port", String.valueOf(installProps.getJmsPort()));
        if (installProps.getAgentId() != null) {
            this.setProperty(outputProps, "locked/agent.id", installProps.getAgentId());
        }
        for (Map.Entry<String, String> ent : installProps.getProperties().entrySet()) {
            this.setProperty(outputProps, ent.getKey(), ent.getValue());
        }
        outputProps.store(new FileOutputStream(file), null);
    }

    private void setProperty(Properties props, String key, Integer value) {
        props.setProperty(key, value == null ? "" : String.valueOf(value));
    }

    private void setProperty(Properties props, String key, String value) {
        props.setProperty(key, value == null ? "" : value);
    }
}

