/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.redaction;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.redaction.DescendingLengthComparator;
import com.urbancode.commons.util.redaction.Redactor;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class RedactingWriter
extends Writer {
    private final Redactor redactor = new Redactor();
    private final String[] sortedSecureValues;
    private final Writer out;
    private StringBuilder buffer = new StringBuilder();

    public RedactingWriter(Writer out, Set<String> secureValues) {
        this.out = out;
        HashSet<String> newSet = new HashSet<String>();
        for (String secureValue : secureValues) {
            newSet.add(this.redactor.normalize(secureValue));
        }
        newSet.remove(null);
        newSet.remove("");
        this.sortedSecureValues = newSet.toArray(new String[0]);
        Arrays.sort(this.sortedSecureValues, new DescendingLengthComparator());
    }

    protected String[] getSecureValues() {
        return this.sortedSecureValues;
    }

    protected boolean hasSecureValues() {
        return this.sortedSecureValues.length != 0;
    }

    @Override
    public synchronized void write(char[] buffer, int offset, int length) throws IOException {
        if (!this.hasSecureValues()) {
            this.out.write(buffer, offset, length);
        } else {
            this.buffer.append(buffer, offset, length);
            this.flush0();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.hasSecureValues()) {
            this.flush0();
        }
        this.out.flush();
    }

    private synchronized void flush0() throws IOException {
        int safePrefixLen = this.redactor.safePrefixLength(this.sortedSecureValues, this.buffer);
        if (safePrefixLen > 0) {
            this.out.write(this.redactor.redact(this.sortedSecureValues, this.buffer.substring(0, safePrefixLen)));
            if (safePrefixLen == this.buffer.length()) {
                this.buffer = new StringBuilder();
            } else {
                this.buffer.delete(0, safePrefixLen);
            }
        }
    }

    public synchronized void finish() throws IOException {
        if (this.hasSecureValues()) {
            this.out.write(this.redactor.redact(this.getSecureValues(), this.buffer.toString()));
            this.buffer = new StringBuilder();
        }
    }

    @Override
    public void close() throws IOException {
        this.finish();
        this.out.close();
    }
}

