/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper
import java.util.concurrent.*

def apTool = new AirPluginTool(this.args[0], this.args[1])

def props = apTool.getStepProperties()

def workDir = new File(".")
def ch = new CommandHelper(workDir)
def clusterName = props['cluster']
def resourceList = props['resource']?.tokenize(',')?.findAll{ it && it.trim().length() > 0 }?.collectAll{ it.trim() }
boolean parallel = props['parallel'].equals("true")
def exceptionsThrown = 0

def threadList = []
if (parallel) {
    def pool = Executors.newFixedThreadPool(resourceList.size())
    def futures = []
    def defer = { c -> futures << pool.submit(c as Callable) }
    
    stop = { resource ->
      defer { stopResource(resource, clusterName, ch) }
    }
    
    resourceList.each{ resource ->
        println "Sending command to stop resource ${resource}."
        stop(resource)
        }
    pool.shutdown()
    for (future in futures) {
        exceptionsThrown += future.get()
    }
}
else {
    for (resourceName in resourceList) {
        exceptionsThrown += stopResource(resourceName, clusterName, ch)
    }
}
if (exceptionsThrown) {
    throw new java.lang.Exception("${exceptionsThrown} exception(s) were thrown in these commands. Failing the step.")
}
println "All commands succeeded."

def stopResource(def resourceName, def clusterName, def ch) {
    try {
        resourceName = "'" + resourceName + "'"
        def args = ['Powershell.exe', 'import-module', 'FailoverClusters', ';', 'Stop-ClusterResource']
        
        args << '-name'
        args << resourceName
        if (clusterName) {
            args << '-cluster'
            args << clusterName
        }
        
        ch.runCommand("Taking the resource ${resourceName} offline.", args)
        println "The resource was taken offline."
        return 0
    }
    catch (Exception e) {
        e.printStackTrace()
        return 1
    }

}