/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper
import java.util.concurrent.*

def apTool = new AirPluginTool(this.args[0], this.args[1])

def props = apTool.getStepProperties()

def workDir = new File(".")
def ch = new CommandHelper(workDir)
def clusterName = props['cluster']
def resourceList = props['resource']?.tokenize(',')?.findAll{ it && it.trim().length() > 0 }?.collectNested{ it.trim() }
boolean parallel = props['parallel'].equals("true")
def exceptionsThrown = 0

def threadList = []
if (parallel) {
    def pool = Executors.newFixedThreadPool(resourceList.size())
    def futures = []
    def defer = { c -> futures << pool.submit(c as Callable) }

    start = { resource ->
      defer { startResource(resource, clusterName, ch) }
    }

    resourceList.each{ resource ->
        println "Sending command to start resource ${resource}."
        start(resource)
        }
    pool.shutdown()
    for (future in futures) {
        exceptionsThrown += future.get()
    }
}
else {
    for (resourceName in resourceList) {
        exceptionsThrown += startResource(resourceName, clusterName, ch)
    }
}
if (exceptionsThrown) {
    throw new java.lang.Exception("${exceptionsThrown} exception(s) were thrown in these commands. Failing the step.")
}
println "All commands succeeded."

def startResource(def resourceName, def clusterName, def ch) {
    try {
        resourceName = "'" + resourceName + "'"
        def args = ['Powershell.exe', 'import-module', 'FailoverClusters', ';', 'Start-ClusterResource']

        args << '-name'
        args << resourceName
        if (clusterName) {
            args << '-cluster'
            args << clusterName
        }

        def result = ch.runCommand("Bringing the resource ${resourceName} online.", args) { Process proc ->
            proc.out.close() // close stdin
            proc.consumeProcessErrorStream(System.out) // forward stderr
            outputText = proc.text.trim();
        }
        if (outputText.contains("Failed")) {
            result = 1
        }
        println result ? "The resource failed to come online." : "The resource was brought online."
        return result
    }
    catch (Exception e) {
        e.printStackTrace()
        return 1
    }

}