/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.runtime;

import com.urbancode.air.plugin_command.Utils;
import com.urbancode.air.plugin_command.runtime.CacheEntry;
import com.urbancode.air.plugin_command.runtime.Fetcher;
import com.urbancode.air.plugin_command.runtime.FetcherException;
import com.urbancode.commons.util.Check;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;

public class CacheManager {
    private static final Logger log = Logger.getLogger(CacheManager.class);
    private final Map<String, CacheEntry> cacheLookup = new HashMap<String, CacheEntry>();
    private final Fetcher fetcher;
    private final ExecutorService cleanupExecutor = Executors.newSingleThreadExecutor();

    public CacheManager(Fetcher fetcher) {
        File[] pluginDirs;
        Check.nonNull((Object)fetcher, (String)"fetcher was null");
        this.fetcher = fetcher;
        File baseDir = this.fetcher.getBaseDir();
        if (!baseDir.isDirectory()) {
            log.debug((Object)("Plugin base directory doesn't exist.  Creating it: " + baseDir.getPath()));
            baseDir.mkdirs();
        }
        for (File pluginDir : pluginDirs = Utils.directoryNameFilter(baseDir, "*_*_*")) {
            String pluginDirName = pluginDir.getName();
            log.trace((Object)("Found plugin directory name: " + pluginDirName));
            Pattern pattern = Pattern.compile("([^_]+)_([\\d]+)_(.+)");
            Matcher matcher = pattern.matcher(pluginDirName);
            if (!matcher.find()) {
                throw new IllegalArgumentException("Plugin directory name '" + pluginDirName + "' is invalid.  Expected the form: <ID>_<VERSION>_<HASH>");
            }
            String id = matcher.group(1);
            Long version = Long.valueOf(matcher.group(2));
            String hash = matcher.group(3);
            CacheEntry entry = this.addNewCacheEntry(id, version, hash);
            entry.setCacheBase(pluginDir);
        }
        log.debug((Object)("Initializing CacheManager with the following entries: " + this.cacheLookup));
    }

    protected Fetcher getFetcher() {
        return this.fetcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheEntry getEntry(String id, Long version) throws FetcherException {
        CacheEntry result = null;
        String hash = this.fetcher.getHash(id, version);
        String key = this.getKey(id, version, hash);
        Map<String, CacheEntry> map = this.cacheLookup;
        synchronized (map) {
            result = this.cacheLookup.get(key);
            if (result == null) {
                log.trace((Object)("Didn't find key '" + key + "' in cache.  Attempting to download."));
                result = this.addNewCacheEntry(id, version, hash);
            } else {
                log.trace((Object)("Found CacheEntry for key '" + key + "'.  Skipping download."));
            }
        }
        result.lock();
        return result;
    }

    private CacheEntry addNewCacheEntry(String id, Long version, String hash) {
        CacheEntry result = new CacheEntry(this, id, version, hash);
        String key = this.getKey(id, version, hash);
        this.cacheLookup.put(key, result);
        return result;
    }

    public void shutdown() {
        this.cleanupExecutor.shutdown();
    }

    public void awaitTermination() throws InterruptedException {
        this.cleanupExecutor.awaitTermination(10L, TimeUnit.SECONDS);
    }

    protected String getKey(String pluginId, Long pluginVersion, String pluginHash) {
        byte[] sub = new byte[16];
        byte[] decoded = pluginHash.getBytes();
        int minLength = Math.min(sub.length, decoded.length);
        System.arraycopy(decoded, 0, sub, 0, minLength);
        String subHash = String.valueOf(Hex.encodeHex((byte[])sub));
        String key = pluginId + "_" + pluginVersion + "_" + subHash;
        return key;
    }

    protected File fetch(String id, Long version, String hash) throws FetcherException {
        return this.fetcher.fetch(id, version, hash);
    }

    public File getBaseDir() {
        return this.fetcher.getBaseDir();
    }
}

