/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.runtime;

import com.urbancode.air.plugin_command.runtime.Fetcher;
import com.urbancode.air.plugin_command.runtime.FetcherException;
import com.urbancode.commons.fileutils.digest.DigestUtil;
import com.urbancode.commons.util.IO;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.apache.log4j.Logger;

public class FetcherLocal
extends Fetcher {
    private static final Logger logger = Logger.getLogger(FetcherLocal.class);
    private File storageDir = null;

    public FetcherLocal(File storageDir) {
        if (storageDir != null && storageDir.isDirectory()) {
            this.storageDir = storageDir.getAbsoluteFile();
        } else {
            String tmpDirStr = System.getProperty("java.io.tmpdir");
            File tmpDir = new File(tmpDirStr);
            logger.warn((Object)("Supplied Fetcher storage directory '" + storageDir + "' does not exist. Using system temp dir '" + tmpDir.getPath() + "'."));
            this.storageDir = tmpDir;
        }
    }

    protected File fetch(String pluginId, Long version, String hash) throws FetcherException {
        File result = new File(this.storageDir, pluginId + "_" + version + "_" + hash);
        if (!result.isDirectory()) {
            File pluginFile = new File(this.storageDir, pluginId + "_" + version + ".zip");
            if (!pluginFile.isFile()) {
                throw new FetcherException("Could not find Plugin: " + pluginFile.getPath());
            }
            if (!pluginFile.canRead()) {
                throw new FetcherException("Could not read Plugin: " + pluginFile.getPath());
            }
            try {
                IO.unzip((File)pluginFile, (File)result);
            }
            catch (IOException e) {
                throw new FetcherException("Failed to extract zip");
            }
        }
        return result;
    }

    protected String getHash(String id, Long version) throws FetcherException {
        File pluginFile = new File(this.storageDir, id + "_" + version + ".zip");
        String serverFileName = pluginFile.getName();
        if (!pluginFile.isFile() && !(pluginFile = new File(this.storageDir, id + "-" + version + ".zip")).isFile()) {
            throw new FetcherException("Could not find Plugin in directory '" + pluginFile.getParent() + "' with name '" + serverFileName + "' or '" + pluginFile.getName() + "'.");
        }
        if (!pluginFile.canRead()) {
            throw new FetcherException("Could not read Plugin: " + pluginFile.getPath());
        }
        String result = null;
        try {
            result = DigestUtil.getHexDigest((File)pluginFile, (String)"SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not find algorithm 'SHA-256'.", e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    protected File getBaseDir() {
        return this.storageDir;
    }
}

