/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.runtime;

import com.urbancode.air.plugin_command.Arg;
import com.urbancode.air.plugin_command.AutomationPlugin;
import com.urbancode.air.plugin_command.Command;
import com.urbancode.air.plugin_command.CommandLine;
import com.urbancode.air.plugin_command.postprocess.PostProcessRuntime;
import com.urbancode.air.plugin_command.properties.PluginCommandProperty;
import com.urbancode.air.plugin_command.properties.PropertyResolver;
import com.urbancode.air.plugin_command.properties.PropertyValueMissingException;
import com.urbancode.air.plugin_command.properties.PropertyValueScope;
import com.urbancode.air.plugin_command.properties.RequiredPropertyValidator;
import com.urbancode.air.plugin_command.redaction.RedactingPrintStream;
import com.urbancode.air.plugin_command.runtime.AutomationPluginRuntimeException;
import com.urbancode.air.plugin_command.runtime.CacheEntry;
import com.urbancode.air.plugin_command.runtime.CacheManager;
import com.urbancode.air.plugin_command.runtime.Fetcher;
import com.urbancode.air.plugin_command.runtime.FetcherHttp;
import com.urbancode.air.plugin_command.runtime.HttpConnectionSettings;
import com.urbancode.air.plugin_command.runtime.ShellHelper;
import com.urbancode.air.plugin_command.runtime.StepExecutionInfo;
import com.urbancode.air.plugin_command.validation.PluginCommandValidator;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.commons.util.WildcardToRegex;
import com.urbancode.commons.util.windows.CmdUtil;
import com.urbancode.commons.xml.marshall.MarshallingContext;
import com.urbancode.commons.xml.marshall.MarshallingEngine;
import com.urbancode.shell.impersonation.ImpersonationToken;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutomationPluginRuntime {
    private static final Logger logger = Logger.getLogger(AutomationPluginRuntime.class);
    static final String INPUT_PROPS_ARG = "PLUGIN_INPUT_PROPS";
    static final String OUTPUT_PROPS_ARG = "PLUGIN_OUTPUT_PROPS";
    private final CacheManager cacheManager;
    private final MarshallingEngine marshallingEngine;
    private boolean displayDetailsInOutput = false;

    public AutomationPluginRuntime(Fetcher fetcher, MarshallingEngine marshallingEngine) throws IOException {
        Check.nonNull((Object)fetcher, (String)"fetcher");
        Check.nonNull((Object)marshallingEngine, (String)"marshalling engine");
        this.cacheManager = new CacheManager(fetcher);
        this.marshallingEngine = marshallingEngine;
    }

    private AutomationPlugin loadPlugin(File pluginHomeDirectory) throws Exception {
        logger.debug((Object)("AutomationPlugin home directory: " + pluginHomeDirectory.getPath()));
        File configFile = new File(pluginHomeDirectory, "plugin.xml");
        PluginCommandValidator validator = new PluginCommandValidator();
        Document doc = validator.validateAndTransform(configFile);
        MarshallingContext context = new MarshallingContext();
        try {
            this.marshallingEngine.unmarshall(doc.getDocumentElement(), context);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        AutomationPlugin result = (AutomationPlugin)context.get();
        return result;
    }

    public void abortCommand(StepExecutionInfo info) {
        ShellHelper.getInstance().abort(info);
    }

    public void executeCommand(String pluginId, Long pluginVersion, String commandName, File inputPropFile, File envPropFile, File outputPropFile, File workingDirectory, File outputLogFile, File errorLogFile, Set<String> secureValues, ImpersonationToken impToken, StepExecutionInfo info) throws Exception {
        this.executeCommand(pluginId, pluginVersion, commandName, inputPropFile, envPropFile, outputPropFile, workingDirectory, outputLogFile, errorLogFile, secureValues, impToken, info, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void executeCommand(String pluginId, Long pluginVersion, String commandName, File inputPropFile, File envPropFile, File outputPropFile, File workingDirectory, File outputLogFile, File errorLogFile, Set<String> secureValues, ImpersonationToken impToken, StepExecutionInfo info, String postProcBody) throws Exception {
        block65: {
            try {
                Object outputLogStream;
                String key;
                String proxyPort;
                String proxyHost;
                CacheEntry cacheEntry;
                File pluginHomeDirectory;
                AutomationPlugin automationPlugin;
                if (pluginId == null) {
                    logger.error((Object)"No pluginId was given to executeCommand().");
                    throw new NullPointerException("No pluginId was give to executeCommand()");
                }
                if (pluginVersion == null) {
                    logger.error((Object)"No pluginVersion was given to executeCommand().");
                    throw new NullPointerException("No pluginVersion was give to executeCommand()");
                }
                if (commandName == null) {
                    logger.error((Object)"No commandName was given to executeCommand().");
                    throw new NullPointerException("No commandName was give to executeCommand()");
                }
                if (commandName.length() == 0) {
                    logger.error((Object)"Empty commandName was given to executeCommand().");
                    throw new NullPointerException("Empty commandName was give to executeCommand()");
                }
                if (inputPropFile == null) {
                    logger.error((Object)"No inputPropsFile was given to executeCommand().");
                    throw new NullPointerException("No inputPropsFile was give to executeCommand()");
                }
                if (envPropFile == null) {
                    logger.error((Object)"No envPropsFile was given to executeCommand().");
                    throw new NullPointerException("No envPropsFile was give to executeCommand()");
                }
                if (outputPropFile == null) {
                    logger.error((Object)"No outputPropFile was given to executeCommand().");
                    throw new NullPointerException("No outputPropFile was give to executeCommand()");
                }
                outputLogFile.createNewFile();
                errorLogFile.createNewFile();
                if (!workingDirectory.isDirectory()) {
                    throw new IOException("Working directory '" + workingDirectory.getAbsolutePath() + "' could not be found.");
                }
                if (!outputLogFile.canWrite()) {
                    throw new IOException("Log file '" + outputLogFile.getAbsolutePath() + "' is not writable.");
                }
                if (!errorLogFile.canWrite()) {
                    throw new IOException("Log file '" + errorLogFile.getAbsolutePath() + "' is not writable.");
                }
                Properties inputProps = new Properties();
                FileInputStream inputPropsStream = null;
                try {
                    inputPropsStream = new FileInputStream(inputPropFile);
                    inputProps.load(inputPropsStream);
                }
                catch (Throwable throwable) {
                    IO.close(inputPropsStream);
                    throw throwable;
                }
                IO.close((InputStream)inputPropsStream);
                PropertyValueScope commandPropertyScope = new PropertyValueScope(inputProps);
                Properties envProps = new Properties();
                FileInputStream envPropsStream = null;
                try {
                    envPropsStream = new FileInputStream(envPropFile);
                    envProps.load(envPropsStream);
                }
                catch (Throwable throwable) {
                    IO.close(envPropsStream);
                    throw throwable;
                }
                IO.close((InputStream)envPropsStream);
                Fetcher fetcher = this.cacheManager.getFetcher();
                if (fetcher instanceof FetcherHttp) {
                    String webUrl = envProps.containsKey("WEB_URL") ? envProps.getProperty("WEB_URL") : envProps.getProperty("AH_WEB_URL");
                    HttpConnectionSettings httpConn = new HttpConnectionSettings(webUrl);
                    ((FetcherHttp)fetcher).setHttpConnectionSettings(httpConn);
                }
                if ((automationPlugin = this.loadPlugin(pluginHomeDirectory = (cacheEntry = this.cacheManager.getEntry(pluginId, pluginVersion)).getCacheBase())) == null) {
                    throw new AutomationPluginRuntimeException("Could not load the Plugin from '" + pluginHomeDirectory + "'.");
                }
                if (!automationPlugin.hasCommand(commandName)) {
                    throw new RuntimeException("Could not find Command '" + commandName + "' configured in" + " AutomationPlugin '" + automationPlugin.getId() + "'.");
                }
                inputPropFile.createNewFile();
                outputPropFile.createNewFile();
                envProps.put("PLUGIN_HOME", pluginHomeDirectory.getAbsolutePath());
                String agentHome = System.getenv().get("AGENT_HOME");
                if (agentHome != null) {
                    envProps.put("AGENT_HOME", agentHome);
                }
                if (!StringUtil.isEmpty((String)(proxyHost = System.getProperty("http.proxyHost")))) {
                    envProps.put("PROXY_HOST", proxyHost);
                }
                if (!StringUtil.isEmpty((String)(proxyPort = System.getProperty("http.proxyPort")))) {
                    envProps.put("PROXY_PORT", proxyPort);
                }
                try {
                    RequiredPropertyValidator requiredPropValidator = new RequiredPropertyValidator(commandPropertyScope);
                    requiredPropValidator.validate(automationPlugin.getRequiredProperties(commandName));
                }
                catch (PropertyValueMissingException e) {
                    List<PluginCommandProperty> propsWithNoValue = e.getListOfPluginPropertiesWithNoValues();
                    Iterator<PluginCommandProperty> iterator = propsWithNoValue.iterator();
                    StringBuilder sb = new StringBuilder("Error executing Plugin Command. The following properties are required but have missing values: ");
                    sb.append(iterator.next().getName());
                    while (iterator.hasNext()) {
                        sb.append(", ").append(iterator.next().getName());
                    }
                    throw new AutomationPluginRuntimeException(sb.toString());
                }
                Command command = automationPlugin.getCommandByName(commandName);
                CommandLine commandLine = command.getCommand();
                for (String propertyWildcardString : command.getPropertyToEnvironmentList()) {
                    Pattern p = WildcardToRegex.convert((String)propertyWildcardString);
                    for (Map.Entry<Object, Object> entry : commandPropertyScope.getAllProperties().entrySet()) {
                        key = (String)entry.getKey();
                        Matcher m = p.matcher(key);
                        if (!m.matches()) continue;
                        String value = (String)entry.getValue();
                        envProps.put(key, value);
                    }
                }
                PropertyValueScope environmentPropertyScope = new PropertyValueScope(envProps);
                environmentPropertyScope.setParent(new PropertyValueScope(System.getenv()));
                commandPropertyScope.setParent(environmentPropertyScope);
                commandPropertyScope.put(INPUT_PROPS_ARG, inputPropFile.getAbsolutePath());
                commandPropertyScope.put(OUTPUT_PROPS_ARG, outputPropFile.getAbsolutePath());
                PropertyResolver resolver = new PropertyResolver(commandPropertyScope);
                Properties resolvedEnvProps = new Properties();
                for (Map.Entry<Object, Object> entry : envProps.entrySet()) {
                    key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    key = resolver.resolve(key);
                    value = resolver.resolve(value);
                    resolvedEnvProps.setProperty(key, value);
                }
                ArrayList<String> commandArgsList = new ArrayList<String>();
                logger.debug((Object)("Resolving using these values:\n" + commandPropertyScope.toString()));
                commandArgsList.add(resolver.resolve(commandLine.getProgram()));
                for (Arg arg : commandLine.getArgs()) {
                    commandArgsList.add(this.resolveCommandLineArg(arg, resolver, pluginHomeDirectory));
                }
                Properties resolvedCommandProperties = new Properties();
                Properties commandProperties = commandPropertyScope.getCurrentProperties();
                for (Map.Entry<Object, Object> entry : commandProperties.entrySet()) {
                    resolvedCommandProperties.put(entry.getKey(), resolver.resolve((String)entry.getValue()));
                }
                FileOutputStream inputPropFileOutputStream = null;
                try {
                    inputPropFileOutputStream = new FileOutputStream(inputPropFile);
                    resolvedCommandProperties.store(inputPropFileOutputStream, "Resolved Props");
                }
                catch (Exception e) {
                    IO.close((OutputStream)inputPropFileOutputStream);
                    catch (Throwable throwable) {
                        IO.close(inputPropFileOutputStream);
                        throw throwable;
                    }
                }
                IO.close((OutputStream)inputPropFileOutputStream);
                Properties outputProperties = new Properties();
                RedactingPrintStream redactingOutputPrinter = null;
                try {
                    Process externalProc;
                    block68: {
                        outputLogStream = new FileOutputStream(outputLogFile);
                        PrintStream outputPrintStream = new PrintStream((OutputStream)outputLogStream, true);
                        redactingOutputPrinter = new RedactingPrintStream(outputPrintStream, secureValues);
                        this.preprocessCommandLineForOsSpecifics(redactingOutputPrinter, redactingOutputPrinter, resolvedEnvProps, commandArgsList, workingDirectory, impToken);
                        if (this.displayDetailsInOutput) {
                            redactingOutputPrinter.println("================================================================================");
                            redactingOutputPrinter.println("plugin: " + automationPlugin.getName() + ", id: " + automationPlugin.getId() + ", version: " + automationPlugin.getVersion());
                            redactingOutputPrinter.println("plugin command: " + this.commandLineToString(commandArgsList));
                            redactingOutputPrinter.println("working directory: " + workingDirectory.getCanonicalPath());
                            redactingOutputPrinter.println("properties:\n" + this.propsToString(resolvedCommandProperties));
                            redactingOutputPrinter.println("environment:\n" + this.propsToString(resolvedEnvProps));
                            redactingOutputPrinter.println("================================================================================");
                        }
                        externalProc = ShellHelper.getInstance().executeShellAndWait(redactingOutputPrinter, redactingOutputPrinter, resolvedEnvProps, commandArgsList, workingDirectory, impToken, info);
                        cacheEntry.unlock();
                        if (!outputPropFile.canRead()) break block68;
                        FileInputStream outputPropertiesStream = null;
                        try {
                            outputPropertiesStream = new FileInputStream(outputPropFile);
                            outputProperties.load(outputPropertiesStream);
                        }
                        catch (Throwable throwable) {
                            IO.close(outputPropertiesStream);
                            throw throwable;
                        }
                        IO.close((InputStream)outputPropertiesStream);
                        ((InputStream)outputPropertiesStream).close();
                    }
                    int exitValue = 1;
                    if (externalProc != null) {
                        exitValue = externalProc.exitValue();
                    }
                    outputProperties.setProperty("exitCode", String.valueOf(exitValue));
                    boolean defaultPostScript = false;
                    if (postProcBody == null || postProcBody.length() == 0) {
                        defaultPostScript = true;
                        postProcBody = automationPlugin.getPostProcessingScript(commandName);
                    }
                    ByteArrayOutputStream postOutputStream = null;
                    try {
                        postOutputStream = new ByteArrayOutputStream();
                        if (!defaultPostScript) {
                            String consoleMsg = String.format("%n================================================================================%n", new Object[0]);
                            consoleMsg = consoleMsg + String.format("Post Processing Script Execution Console Output:%n%n", new Object[0]);
                            postOutputStream.write(consoleMsg.getBytes());
                        }
                        PostProcessRuntime.evaluate(outputLogFile, outputProperties, postProcBody, postOutputStream);
                        redactingOutputPrinter.write(postOutputStream.toByteArray());
                    }
                    finally {
                        IO.close((OutputStream)postOutputStream);
                    }
                }
                catch (Throwable throwable) {
                    IO.close(redactingOutputPrinter);
                    throw throwable;
                }
                IO.close((OutputStream)redactingOutputPrinter);
                outputLogStream = info;
                synchronized (outputLogStream) {
                    if (info.isAborted()) {
                        outputProperties.setProperty("Status", "PLUGIN_TASK_CANCELLED");
                    }
                }
                logger.trace((Object)"OutputProps : ");
                for (Map.Entry<Object, Object> ent : outputProperties.entrySet()) {
                    logger.trace((Object)(ent.getKey().getClass().getName() + " : " + ent.getKey() + " = " + ent.getValue().getClass().getName() + " : " + ent.getValue()));
                }
                if (outputPropFile.canWrite()) {
                    logger.trace((Object)("outputProperties:\n" + outputProperties.toString()));
                    FileOutputStream outPropStream = null;
                    try {
                        outPropStream = new FileOutputStream(outputPropFile);
                        outputProperties.store(outPropStream, "After Post Process");
                    }
                    catch (Throwable throwable) {
                        IO.close(outPropStream);
                        throw throwable;
                    }
                    IO.close((OutputStream)outPropStream);
                }
                if (outputProperties.containsKey("Status")) break block65;
                logger.trace((Object)"Property 'Status' not returned by plugin task.");
                PrintStream errStream = null;
                try {
                    FileOutputStream errLogStream = new FileOutputStream(errorLogFile);
                    errStream = new PrintStream(errLogStream);
                    errStream.println("Error: Property 'Status' not returned by plugin task. Execution result status indeterminate. Failing task...");
                    errStream.println("    ***NOTE*** If you are using a Post-Process script you must set the 'Status' output property ***NOTE***");
                    errStream.flush();
                    IO.close((OutputStream)errStream);
                }
                catch (Exception ex) {
                    logger.error((Object)"Could not write error to error log!");
                }
                finally {
                    IO.close(errStream);
                }
            }
            catch (Exception e) {
                PrintStream errStream = null;
                try {
                    FileOutputStream errorLogStream = new FileOutputStream(errorLogFile);
                    errStream = new PrintStream(errorLogStream);
                    e.printStackTrace(errStream);
                    IO.close((OutputStream)errStream);
                }
                catch (Exception ex) {
                    logger.error((Object)"Could not write exception to error log!");
                }
                finally {
                    IO.close(errStream);
                }
                throw e;
            }
        }
    }

    protected String resolveCommandLineArg(Arg arg, PropertyResolver resolver, File pluginHome) throws Exception {
        String result;
        String value = arg.getValue();
        switch (arg.getType()) {
            case VALUE: {
                result = resolver.resolve(arg.getValue());
                break;
            }
            case FILE: {
                result = this.convertFileArg(value, resolver, pluginHome);
                break;
            }
            case PATH: {
                result = this.convertPathArg(value, resolver, pluginHome);
                break;
            }
            default: {
                throw new Exception("Did not recognize command argument type '" + (Object)((Object)arg.getType()) + "'.");
            }
        }
        return result;
    }

    protected String convertFileArg(String fileValue, PropertyResolver resolver, File pluginHome) {
        fileValue = resolver.resolve(fileValue);
        File file = new File(fileValue = fileValue.replace('\\', File.separatorChar).replace('/', File.separatorChar));
        if (!file.isAbsolute()) {
            file = new File(pluginHome, fileValue);
        }
        return file.getAbsolutePath();
    }

    protected String convertPathArg(String pathValue, PropertyResolver resolver, File pluginHome) {
        pathValue = resolver.resolve(pathValue);
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        boolean isDOS = File.pathSeparatorChar == ';';
        String[] parts = pathValue.split("[:;]+");
        for (int i = 0; i < parts.length; ++i) {
            String nextToken;
            String part = parts[i];
            if (part == null || part.length() == 0) continue;
            if (isDOS && part.length() == 1 && Character.isLetter(part.charAt(0)) && parts.length > i + 1 && ((nextToken = parts[i + 1]).startsWith("\\") || nextToken.startsWith("/"))) {
                ++i;
                part = part + ":" + nextToken;
            }
            paths.add(part);
        }
        String[] result = paths.toArray(new String[0]);
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.convertFileArg(result[i], resolver, pluginHome);
        }
        return StringUtil.join((String[])result, (String)File.pathSeparator);
    }

    protected void preprocessCommandLineForOsSpecifics(OutputStream outputLogStream, OutputStream errorLogStream, Properties resolvedEnvProps, List<String> commandLine, File workingDirectory, ImpersonationToken impToken) throws Exception {
        File execFile;
        String executable = commandLine.get(0);
        if ("unix".equals(ShellHelper.getInstance().getOs()) && executable.startsWith(this.cacheManager.getBaseDir().getPath()) && (execFile = new File(executable)).isFile()) {
            LinkedList<String> chmodCommand = new LinkedList<String>();
            chmodCommand.add("chmod");
            chmodCommand.add("a+x");
            chmodCommand.add(executable);
            ShellHelper.getInstance().executeShellAndWait(outputLogStream, errorLogStream, resolvedEnvProps, chmodCommand, workingDirectory, impToken, new StepExecutionInfo(UUID.randomUUID()));
        }
        if ("windows".equals(ShellHelper.getInstance().getOs())) {
            String newCommand = CmdUtil.buildCommand(commandLine);
            commandLine.clear();
            commandLine.add("cmd");
            commandLine.add("/C");
            commandLine.add(newCommand);
        }
    }

    private String commandLineToString(List<String> commandLine) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String arg : commandLine) {
            if (!first) {
                sb.append(" ");
            }
            first = false;
            sb.append("'" + arg + "'");
        }
        return sb.toString();
    }

    private String propsToString(Properties properties) {
        ArrayList<String> envPropNames = new ArrayList<String>();
        for (Object key : properties.keySet()) {
            envPropNames.add(String.valueOf(key));
        }
        Collections.sort(envPropNames);
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (String envPropName : envPropNames) {
            if (!first) {
                sb.append("\n");
            }
            sb.append("  ");
            first = false;
            sb.append(envPropName).append("=").append(properties.get(envPropName));
        }
        return sb.toString();
    }

    public boolean isDisplayDetailsInOutput() {
        return this.displayDetailsInOutput;
    }

    public void setDisplayDetailsInOutput(boolean displayDetailsInOutput) {
        this.displayDetailsInOutput = displayDetailsInOutput;
    }
}

