import com.urbancode.air.CommandHelper

final def out = System.out
final def workDir = new File('.').canonicalFile

final def props = new Properties()
final def inputPropsFile = new File(args[0])
final def inputPropsStream = null
try {
    inputPropsStream = new FileInputStream(inputPropsFile)
    props.load(inputPropsStream)
}
catch (IOException e) {
    throw new RuntimeException(e)
}

def queues = props['queues']
def transQueues = props['transQueues']
final def scriptFile = new File(workDir, 'create_queues.vbs')

def cscriptExe = "cscript.exe"
if (new File("C:\\Windows\\SysWOW64").exists()) {
    cscriptExe = "C:\\Windows\\SysWOW64\\cscript.exe"
}

//------------------------------------------------------------------------------
// Generate VB Script
//------------------------------------------------------------------------------

scriptFile.withPrintWriter { writer ->
    writer.println "On Error Resume Next"
    queues?.split('\n')?.each {
        writer.println "set mq = CreateObject(\"MSMQ.MSMQQueueInfo\")"
        writer.println "mq.PathName=\"$it\""
        writer.println "WScript.Echo \"Creating non-transactional queue $it\""
        writer.println "mq.Create False"
        writer.println "If Err <> 0 Then"
        writer.println "\tWScript.Echo \"Queue already exists!\""
        writer.println "\t Err.Clear"
        writer.println "End If"
    }

    transQueues?.split('\n')?.each {
        writer.println "set mq = CreateObject(\"MSMQ.MSMQQueueInfo\")"
        writer.println "mq.PathName=\"$it\""
        writer.println "WScript.Echo \"Creating transactional queue $it\""
        writer.println "mq.Create True"
        writer.println "If Err <> 0 Then"
        writer.println "\tWScript.Echo \"Queue already exists!\""
        writer.println "\t Err.Clear"
        writer.println "End If"
    }
}


//------------------------------------------------------------------------------
// Build the command
//------------------------------------------------------------------------------

try {
    new CommandHelper(workDir).runCommand("Execute queue creation script", [cscriptExe, '/nologo', scriptFile] as String[])
}
catch (Exception e) {
    println "Error executing queue creation script: ${e.message}"
    System.exit 1
}
finally {
    scriptFile.delete()
}

System.exit 0