import com.urbancode.air.CommandHelper
import com.urbancode.air.AirPluginTool

final def workDir = new File('.').canonicalFile
def airTool = new AirPluginTool(args[0], args[1])
final def props = airTool.stepProperties

def logName = props['logName']
def source = props['source']
def categoryResourceFile = props['categoryResourceFile']
def messageResourceFile = props['messageResourceFile']
def parameterResourceFile = props['parameterResourceFile']
def powershellExe = props['powershellExe']


println "Log Name: $logName"
println "Sources: $source"
println "Category Resource File: $categoryResourceFile"
println "Message Resource File: $messageResourceFile"
println "Parameter Resource File: $parameterResourceFile"
println "Powershell executable: ${powershellExe?:'powershell.exe'}"
println ""


def powershellCmd = 'powershell'
if (powershellExe && powershellExe.trim().length() > 0) {
    powershellCmd = powershellExe.trim()
}

def sourceArray = source.tokenize(',').findAll { it && it.trim().length() > 0}.collect{ '\'' + it.trim() + '\''}
if (sourceArray.size() == 0) {
    println "Source list is empty! Please provide at least one source!"
    System.exit 1
}

def commandList = ['new-eventlog', '-logname', logName.trim(), '-source', sourceArray.join(',')]

if (categoryResourceFile && categoryResourceFile.trim().length() > 0) {
    commandList << '-categoryresourcefile'
    commandList << categoryResourceFile.trim()
}

if (messageResourceFile && messageResourceFile.trim().length() > 0) {
    commandList << '-messageresourcefile'
    commandList << messageResourceFile.trim()
}

if (parameterResourceFile && parameterResourceFile.trim().length() > 0) {
    commandList << '-parameterresourcefile'
    commandList << parameterResourceFile.trim()
}


def isSuccess = false
try {
    def cmdHelper = new CommandHelper(workDir)
    cmdHelper.ignoreExitValue = true
    def outBuffer = new StringBuffer()
    def exitCode = cmdHelper.runCommand("Executing create event log command", [powershellCmd, '-Command', commandList.join(' ')] as String[]) { Process proc ->
        proc.out.close()
        proc.waitForProcessOutput(outBuffer, outBuffer)
        if (outBuffer.length() > 0) {
            print outBuffer
        }
    }
    
    if (exitCode == 0) {
        isSuccess = true
        println "Event log $logName created/updated successfuly!"
    }
    else {
        outBuffer.toString().eachLine { line ->
            if (line && line.trim().startsWith('New-EventLog :')) {
                if (line.indexOf('source is already registered ') != -1) {
                    isSuccess = true
                }
            }
        }
    }
}
catch (Exception e) {
    println "Error executing create event log command: ${e.message}"
    System.exit 1
}

if (isSuccess) {
    System.exit 0
}
else {
    System.exit 1
}
