import com.urbancode.air.plugin_command.PluginRecoveryObject;
import com.urbancode.air.CommandHelper;
import com.urbancode.commons.util.IO;

final def props = new Properties();
final def inputPropsFile = new File(args[0]);
final def inputPropsStream = null;
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

final def AGENT_HOME = System.getenv("AGENT_HOME");
final def dialogueId = System.getenv("UD_DIALOGUE_ID");

File agentHome= new File(AGENT_HOME);
File recoveryDir = new File(agentHome, "var/recovery");
File recoveryFile = File.createTempFile("recovery", ".rec", recoveryDir);
Properties outProps = new Properties();

outProps.put("Status", "Success");
outProps.put("exitCode", "0");

PluginRecoveryObject pro = new PluginRecoveryObject(dialogueId, 201, "exec_response", outProps);

try {
    recoveryFile.createNewFile();
}
catch (IOException e) {
    log.error("Error creating msg file!", e);
}

try {
    try {
        ObjectOutputStream outStream = new ObjectOutputStream(IO.openOutput(recoveryFile));
        try {
            outStream.writeObject(pro);
        }
        finally {
            outStream.close();
        }
    }
    catch (Exception e) {
        throw e;
    }

    final def time = props['time'];
    
    def ch = new CommandHelper(new File('.'));
    def args = [];
    args = ['shutdown', '-r'];
    if (time != null && time.trim() != "" ) {
        args << '-t';
        args << time;
    }

    ch.runCommand(args.join(' '), args);
    Thread.sleep(9999999999);
}
catch (Exception e) {
    recoveryFile.delete();
    throw e;
}
