/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.runtime;

import com.urbancode.air.plugin_command.Utils;
import com.urbancode.air.plugin_command.runtime.StepExecutionInfo;
import com.urbancode.commons.util.concurrent.WaitFuture;
import com.urbancode.commons.util.processes.Processes;
import com.urbancode.commons.util.unix.Unix;
import com.urbancode.shell.Shell;
import com.urbancode.shell.impersonation.ImpersonationToken;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellHelper {
    private static final Logger logger = Logger.getLogger(ShellHelper.class);
    private static ShellHelper instance = new ShellHelper();
    private String os;
    private String arch;
    private Map<StepExecutionInfo, Shell> procMap = new HashMap<StepExecutionInfo, Shell>();

    public static ShellHelper getInstance() {
        return instance;
    }

    private ShellHelper() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        this.os = osName.contains("windows") ? "windows" : (osName.contains("vms") ? "vms" : (osName.contains("mac") && !osName.endsWith("x") ? "os9" : (new Unix().isUnix() ? "unix" : "unknown")));
        this.arch = Utils.getArch();
    }

    public String getOs() {
        return this.os;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(StepExecutionInfo info) {
        Map<StepExecutionInfo, Shell> map = this.procMap;
        synchronized (map) {
            Shell proc = this.procMap.remove(info);
            if (proc != null) {
                try {
                    proc.killProcess();
                }
                catch (Exception e) {
                    logger.error((Object)"Exception trying to kill process", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Process executeShellAndWait(OutputStream outputStream, OutputStream errorStream, Properties environmentProperties, List<String> command, File workingDirectory, ImpersonationToken impToken, StepExecutionInfo info) throws Exception {
        Object key;
        Shell shell = new Shell(command);
        logger.debug((Object)("Setting working directory to: " + workingDirectory.getPath()));
        shell.setWorkingDirectory(workingDirectory);
        if (impToken != null) {
            logger.debug((Object)("Using user : " + impToken.getUser()));
            logger.debug((Object)("Using group : " + impToken.getGroup()));
            logger.debug((Object)("Using sudo : " + impToken.isUseSudo()));
            shell.setImpersonationToken(impToken);
        }
        logger.debug((Object)("Setting these environment properties on the Shell: " + environmentProperties));
        for (Map.Entry<Object, Object> entry : environmentProperties.entrySet()) {
            key = (String)entry.getKey();
            String value = (String)entry.getValue();
            shell.addEnvironmentVariable((String)key, value);
        }
        if (this.os.contains("windows") && System.getProperty("com.urbancode.winapi.WinAPI.dllPath") == null) {
            File libraryPath = new File(".." + File.separator + "native" + File.separator + this.arch + File.separator + "WinAPI.dll").getAbsoluteFile();
            if (!libraryPath.isFile()) {
                throw new IOException("Could not find native architecture libraries at '" + libraryPath + "'.");
            }
            System.setProperty("com.urbancode.winapi.WinAPI.dllPath", libraryPath.getAbsolutePath());
        }
        Process externalProc = null;
        StepExecutionInfo stepExecutionInfo = info;
        synchronized (stepExecutionInfo) {
            if (!info.isAborted()) {
                logger.debug((Object)("Executing command: " + Arrays.toString(shell.getCommandLine().toStringArray())));
                shell.execute();
                externalProc = shell.getProcess();
                key = this.procMap;
                synchronized (key) {
                    this.procMap.put(info, shell);
                }
            }
        }
        if (externalProc != null) {
            Processes processes = new Processes();
            WaitFuture outputFuture = processes.redirectOutput(externalProc, outputStream);
            WaitFuture errorFuture = processes.redirectError(externalProc, errorStream);
            outputFuture.get();
            errorFuture.get();
            externalProc.waitFor();
            Map<StepExecutionInfo, Shell> map = this.procMap;
            synchronized (map) {
                this.procMap.remove(info);
            }
        }
        return externalProc;
    }

    public void chmodDirectory(File dir, String permission) {
        if ("unix".equals(ShellHelper.getInstance().getOs())) {
            LinkedList<String> chmodCommand = new LinkedList<String>();
            chmodCommand.add("chmod");
            chmodCommand.add("-R");
            chmodCommand.add("a+" + permission);
            chmodCommand.add(dir.getAbsolutePath());
            ByteArrayOutputStream outputLogStream = new ByteArrayOutputStream();
            ByteArrayOutputStream errorLogStream = new ByteArrayOutputStream();
            Properties resolvedEnvProps = new Properties();
            File workingDirectory = new File(".");
            try {
                ShellHelper.getInstance().executeShellAndWait(outputLogStream, errorLogStream, resolvedEnvProps, chmodCommand, workingDirectory, null, new StepExecutionInfo(UUID.randomUUID()));
            }
            catch (Exception e) {
                logger.error((Object)"Failed to chmod plugin directory!", (Throwable)e);
            }
        }
    }

    public void chmodFile(File dir, String permission) {
        if ("unix".equals(ShellHelper.getInstance().getOs())) {
            LinkedList<String> chmodCommand = new LinkedList<String>();
            chmodCommand.add("chmod");
            chmodCommand.add(permission);
            chmodCommand.add(dir.getAbsolutePath());
            ByteArrayOutputStream outputLogStream = new ByteArrayOutputStream();
            ByteArrayOutputStream errorLogStream = new ByteArrayOutputStream();
            Properties resolvedEnvProps = new Properties();
            File workingDirectory = new File(".");
            try {
                ShellHelper.getInstance().executeShellAndWait(outputLogStream, errorLogStream, resolvedEnvProps, chmodCommand, workingDirectory, null, new StepExecutionInfo(UUID.randomUUID()));
            }
            catch (Exception e) {
                logger.error((Object)"Failed to chmod file!", (Throwable)e);
            }
        }
    }
}

