/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.validation;

import com.urbancode.air.plugin_command.schema_migration.SchemaValidationException;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.xml.XPathUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginCommandPathValidator {
    private final ZipFile pluginZipFile;

    public PluginCommandPathValidator(ZipFile pluginZipFile) {
        this.pluginZipFile = pluginZipFile;
    }

    public void assertRelativeFilesExist(Document document, String xpathStringExpression, String typeDescription) throws SchemaValidationException, XPathExpressionException {
        XPathUtils xpath = new XPathUtils();
        Element rootElement = document.getDocumentElement();
        LinkedHashSet<String> missingFiles = new LinkedHashSet<String>();
        List paths = xpath.getXPathTextList(rootElement, xpathStringExpression);
        for (String filePath : paths) {
            boolean valid = this.isValidFileReference(this.collapseTokens(filePath));
            if (valid) continue;
            missingFiles.add(filePath);
        }
        if (!missingFiles.isEmpty()) {
            throw new SchemaValidationException("Plugin references non-existent " + typeDescription + " file(s) " + Arrays.toString(missingFiles.toArray()));
        }
    }

    public void assertRelativePathFilesExist(Document doc, String xpathStringExpression, String typeDescription) throws SchemaValidationException, XPathExpressionException {
        XPathUtils xpath = new XPathUtils();
        Element rootElement = doc.getDocumentElement();
        LinkedHashSet<String> missingPathElements = new LinkedHashSet<String>();
        List paths = xpath.getXPathTextList(rootElement, xpathStringExpression);
        for (String pathRawValue : paths) {
            for (String fileName : this.parsePathElements(pathRawValue)) {
                boolean valid = this.isValidFileReference(fileName);
                if (valid) continue;
                missingPathElements.add(fileName);
            }
        }
        if (!missingPathElements.isEmpty()) {
            throw new SchemaValidationException("Plugin references non-existent " + typeDescription + " file(s) " + Arrays.toString(missingPathElements.toArray()));
        }
    }

    private List<String> parsePathElements(String path) {
        LinkedHashSet<String> pathElements = new LinkedHashSet<String>();
        String[] tokens = this.collapseTokens(path).split("[:;]+");
        for (int i = 0; i < tokens.length; ++i) {
            String nextToken;
            String pathElement = tokens[i];
            if (pathElement.length() == 1 && Character.isLetter(pathElement.charAt(0)) && i < tokens.length + 1 && ((nextToken = tokens[i + 1]).startsWith("\\") || nextToken.startsWith("/"))) {
                pathElement = pathElement + ":" + nextToken;
                ++i;
            }
            pathElements.add(pathElement);
        }
        return new ArrayList<String>(pathElements);
    }

    private boolean isValidFileReference(String pathElement) {
        boolean result;
        boolean isAbsolute;
        boolean hasTokens = this.collapseTokens(pathElement).contains("${}");
        boolean bl = isAbsolute = pathElement.startsWith("/") || pathElement.startsWith("\\") || pathElement.matches("^[a-zA-Z]:[\\\\/].*");
        if (hasTokens || isAbsolute) {
            result = true;
        } else {
            ZipEntry fileEntry = this.pluginZipFile.getEntry(pathElement);
            result = ".".equals(pathElement) || fileEntry != null;
        }
        return result;
    }

    protected String collapseTokens(String value) {
        return value.replaceAll("\\$\\{[^}]*\\}", "\\${}");
    }

    protected InputStream getZipInputStream(String documentName) throws IOException {
        ZipEntry entry = this.pluginZipFile.getEntry(documentName);
        if (entry == null) {
            return null;
        }
        return this.pluginZipFile.getInputStream(entry);
    }

    String loadZipDocument(String documentName) throws IOException {
        ZipEntry entry = this.pluginZipFile.getEntry(documentName);
        return entry == null ? null : IO.readText((Reader)IO.reader((InputStream)this.pluginZipFile.getInputStream(entry)));
    }
}

