/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.schema_migration;

import com.urbancode.air.plugin_command.schema_migration.DocumentReader;
import com.urbancode.air.plugin_command.schema_migration.SchemaValidationException;
import com.urbancode.air.plugin_command.schema_migration.SchemaVersionDescriptor;
import com.urbancode.air.plugin_command.schema_migration.SchemaVersionDescriptorChain;
import com.urbancode.air.plugin_command.schema_migration.SchemaVersionDocValidator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SchemaDocValidator {
    private SchemaVersionDescriptorChain chain;

    public SchemaDocValidator(SchemaVersionDescriptorChain chain) {
        this.chain = chain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document validateAndTransform(File docFile) throws IOException, SchemaValidationException, XPathExpressionException, DOMException {
        Document result = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(docFile);
            result = this.validateAndTransform(stream);
        }
        finally {
            try {
                ((InputStream)stream).close();
            }
            catch (Exception e) {}
        }
        return result;
    }

    public Document validateAndTransform(InputStream docFileIn) throws IOException, SchemaValidationException, XPathExpressionException, DOMException {
        Document doc = null;
        try {
            doc = new DocumentReader().readDocument(docFileIn, true);
        }
        catch (ParserConfigurationException e) {
            throw new SchemaValidationException(e);
        }
        catch (SAXException e) {
            throw new SchemaValidationException(e);
        }
        finally {
            docFileIn.close();
        }
        SchemaVersionDescriptor latestDescriptor = this.chain.getLastDescriptor();
        latestDescriptor.translateDoc(doc);
        SchemaVersionDocValidator latestDocValidator = latestDescriptor.getDocValidator();
        latestDocValidator.validateDocAgainstSchema(doc);
        latestDocValidator.validateDocBeyondSchema(doc);
        return doc;
    }
}

