#!/usr/bin/env groovy
/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper;

def workDir = new File('.').canonicalFile
def ch = new CommandHelper(workDir);
def airTool = new AirPluginTool(args[0], args[1])
final def props = airTool.stepProperties

def taskName = props['taskName'];

def command = 'schtasks'
def subcommand = '/delete'
def cmdArgs = [command, subcommand]


def _addopt = { optstring, value ->
    if (value) {
        cmdArgs << "/" + optstring << value;
    }
}

def addopt = { optstring, value, selector ->
    if (selector != null) {
        if (selector()) {
            _addopt(optstring, value);
        }
    }
    else {
        _addopt(optstring, value);
    }
}

_addopt("TN", taskName);
cmdArgs << "/F"

ch.runCommand("Deleteing Schedule", cmdArgs);
