/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.schema_migration;

import com.urbancode.air.plugin_command.schema_migration.DocumentReader;
import com.urbancode.air.plugin_command.schema_migration.SchemaValidationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SchemaVersionDocValidator {
    public static final String HANDLER_DESCRIPTOR_FILE = "plugin.xml";

    protected abstract List<String> getSchemaNamespaceURIs();

    protected abstract List<String> getSchemaFileNames();

    public void validateDocBeyondSchema(Document doc) throws IOException, SchemaValidationException {
    }

    public void validateDocAgainstSchema(String docText) throws SchemaValidationException {
        if (docText == null) {
            throw new NullPointerException("DocText can't be null.");
        }
        ByteArrayInputStream docStream = new ByteArrayInputStream(docText.getBytes());
        this.validateDocAgainstSchema(docStream);
    }

    public void validateDocAgainstSchema(InputStream docStream) throws SchemaValidationException {
        if (docStream == null) {
            throw new NullPointerException("DocStream can't be null.");
        }
        Document document = null;
        try {
            document = new DocumentReader().readDocument(docStream, true);
        }
        catch (ParserConfigurationException e) {
            throw new SchemaValidationException(e);
        }
        catch (SAXException e) {
            throw new SchemaValidationException(e);
        }
        catch (IOException e) {
            throw new SchemaValidationException(e);
        }
        this.validateDocAgainstSchema(document);
    }

    public void validateDocAgainstSchema(Document document) throws SchemaValidationException {
        if (document == null) {
            throw new NullPointerException("Document can't be null.");
        }
        Schema schema = this.loadSchema(this.getSchemaFileNames());
        HashSet<String> acceptableNamespaces = new HashSet<String>(this.getSchemaNamespaceURIs());
        this.stripUnacceptableNamespaceNodes(document, document.getDocumentElement(), acceptableNamespaces);
        this.validateDocumentWithSchema(schema, document);
    }

    private Schema loadSchema(List<String> schemaFileNameList) throws SchemaValidationException {
        if (schemaFileNameList == null || schemaFileNameList.isEmpty()) {
            throw new NullPointerException("SchemaName can't be null.");
        }
        String schemaLanguage = "http://www.w3.org/2001/XMLSchema";
        SchemaFactory schemaFactory = SchemaFactory.newInstance(schemaLanguage);
        Schema schema = null;
        ArrayList<InputStream> schemaInputList = new ArrayList<InputStream>();
        try {
            ArrayList<StreamSource> schemaSourceList = new ArrayList<StreamSource>();
            for (String schemaFileName : schemaFileNameList) {
                InputStream schemaIn = this.getClass().getResourceAsStream(schemaFileName);
                if (schemaIn == null) {
                    throw new SchemaValidationException("Could not load XSD Schema file: '" + schemaFileName + "' using class loader from " + this.getClass());
                }
                schemaInputList.add(schemaIn);
                StreamSource schemaSource = new StreamSource(schemaIn);
                schemaSourceList.add(schemaSource);
            }
            schema = schemaFactory.newSchema(schemaSourceList.toArray(new StreamSource[0]));
        }
        catch (Exception e) {
            throw new SchemaValidationException("Could not load XSD Schema from sources: " + e.toString(), e);
        }
        finally {
            for (InputStream schemaIn : schemaInputList) {
                try {
                    schemaIn.close();
                }
                catch (IOException e) {
                    throw new SchemaValidationException("Could not close XSD Schema InputStream.", e);
                }
            }
        }
        return schema;
    }

    private void validateDocumentWithSchema(Schema schema, Document document) throws SchemaValidationException {
        DOMSource docSource = new DOMSource(document);
        Validator validator = schema.newValidator();
        try {
            validator.validate(docSource);
        }
        catch (SAXException e) {
            throw new SchemaValidationException("Error parsing plugin.xml file: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SchemaValidationException("Error parsing plugin.xml file: " + e.getMessage(), e);
        }
    }

    private void stripUnacceptableNamespaceNodes(Document doc, Node node, Set<String> acceptableNamespaces) {
        if (9 == node.getNodeType() || 1 == node.getNodeType()) {
            if (acceptableNamespaces.contains(node.getNamespaceURI())) {
                NodeList childNodeList = node.getChildNodes();
                for (int i = 0; i < childNodeList.getLength(); ++i) {
                    Node childNode = childNodeList.item(i);
                    this.stripUnacceptableNamespaceNodes(doc, childNode, acceptableNamespaces);
                }
            } else {
                node.getParentNode().removeChild(node);
            }
        }
    }
}

