/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.schema_migration;

import com.urbancode.commons.util.IO;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SchemaLoader {
    private SAXParser parser;
    private SchemaFactory schemaFactory;
    private Map<String, byte[]> ns2schema = new HashMap<String, byte[]>();
    private RuntimeException targetNamespaceFound = new RuntimeException(){
        private static final long serialVersionUID = 1L;

        public Throwable initCause(Throwable cause) {
            return this;
        }
    };

    public SchemaLoader() {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            parserFactory.setValidating(false);
            parserFactory.setXIncludeAware(false);
            this.parser = parserFactory.newSAXParser();
            this.schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            this.schemaFactory.setResourceResolver(new LSResourceResolver(){

                public LSInput resolveResource(String type, final String namespaceURI, String publicId, String systemId, String baseURI) {
                    if ("http://www.w3.org/2001/XMLSchema".equals(type)) {
                        return new LSInput(){

                            public void setSystemId(String systemId) {
                            }

                            public void setStringData(String stringData) {
                            }

                            public void setPublicId(String publicId) {
                            }

                            public void setEncoding(String encoding) {
                            }

                            public void setCharacterStream(Reader characterStream) {
                            }

                            public void setCertifiedText(boolean certifiedText) {
                            }

                            public void setByteStream(InputStream byteStream) {
                            }

                            public void setBaseURI(String baseURI) {
                            }

                            public String getSystemId() {
                                return null;
                            }

                            public String getStringData() {
                                return null;
                            }

                            public String getPublicId() {
                                return null;
                            }

                            public String getEncoding() {
                                return null;
                            }

                            public Reader getCharacterStream() {
                                return null;
                            }

                            public boolean getCertifiedText() {
                                return false;
                            }

                            public InputStream getByteStream() {
                                byte[] schema = (byte[])SchemaLoader.this.ns2schema.get(namespaceURI);
                                if (schema != null) {
                                    return new ByteArrayInputStream(schema);
                                }
                                return null;
                            }

                            public String getBaseURI() {
                                return null;
                            }
                        };
                    }
                    return null;
                }
            });
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public void addPart(byte[] schema) {
        String ns = this.getNs(schema);
        this.ns2schema.put(ns, schema);
    }

    public void addPartStream(InputStream in) throws IOException {
        this.addPart(IO.read((InputStream)in));
    }

    public void addPartFile(File file) throws IOException {
        this.addPart(IO.readFile((File)file));
    }

    public void addPartFile(String path) throws IOException {
        this.addPart(IO.readFile((File)new File(path)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPartUrl(URL url) throws IOException {
        InputStream stream = url.openStream();
        try {
            this.addPartStream(stream);
        }
        finally {
            IO.closeNoThrow((InputStream)stream);
        }
    }

    public void addPartUrl(String url) throws IOException {
        this.addPartUrl(new URL(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPartUri(URI uri) throws IOException {
        InputStream stream = uri.toURL().openStream();
        try {
            this.addPartStream(stream);
        }
        finally {
            IO.closeNoThrow((InputStream)stream);
        }
    }

    public void addPartUri(String uri) throws IOException {
        this.addPartUrl(uri);
    }

    public void addPartClasspath(String path) {
        InputStream stream;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        if ((stream = loader.getResourceAsStream(path)) == null) {
            throw new RuntimeException("Schema resource not found: " + path);
        }
        try {
            this.addPartStream(stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IO.closeNoThrow((InputStream)stream);
        }
    }

    public Schema getSchema(String namespace) {
        try {
            byte[] schema = this.ns2schema.get(namespace);
            if (schema == null) {
                throw new RuntimeException("Unknown schema " + namespace);
            }
            return this.schemaFactory.newSchema(new StreamSource(new ByteArrayInputStream(schema)));
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private String getNs(byte[] data) {
        final String[] result = new String[1];
        try {
            this.parser.parse((InputStream)new ByteArrayInputStream(data), new DefaultHandler(){

                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if ("http://www.w3.org/2001/XMLSchema".equals(uri) && "schema".equals(localName)) {
                        result[0] = attributes.getValue("targetNamespace");
                        if (result[0] != null) {
                            throw SchemaLoader.this.targetNamespaceFound;
                        }
                    }
                    throw new SAXException("Unparseable schema");
                }
            });
        }
        catch (RuntimeException e) {
            if (e != this.targetNamespaceFound) {
                throw e;
            }
        }
        catch (SAXException e) {
            throw new RuntimeException("Unparseable schema", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unparseable schema", e);
        }
        return result[0];
    }
}

