#!/usr/bin/env groovy
/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper;

def workDir = new File('.').canonicalFile
def ch = new CommandHelper(workDir);
def airTool = new AirPluginTool(args[0], args[1])
final def props = airTool.stepProperties

def taskName = props['taskName'];
def taskRun = props['taskRun'];
def scheduleType = props['scheduleType'];
def modifier = props['modifier'];
def month = props['month']
def day = props['day']
def idletime = props['idletime'];
def starttime = props['starttime'];
def duration = props['duration'];
def startdate = props['startdate'];
def enddate = props['enddate'];


def command = 'schtasks'
def subcommand = '/create'
def cmdArgs = [command, subcommand]

def allowsTypes = { vals ->
    return vals.contains(scheduleType);
}

def allowsMO = {
    return allowsTypes(["MINUTE", "HOURLY","DAILY", "WEEKLY", "MONTHLY", "ONEVENT"]);
}

def allowsMonth = { 
    return allowsTypes(["MONTHLY"]);
}

def allowsDay = {
   return allowsTypes(["MONTHLY", "WEEKLY"]);
}

def onidle = { 
    return allowsTypes(["ONIDLE"])
}


def allowsInterval = { 
    return allowsTypes(["DAILY", "WEEKLY", "MONTHLY", "ONCE"])
}

def allowsTimes = { 
    return allowsTypes(["MINUTE", "HOURLY", "DAILY", "WEEKLY", "MONTHLY"])
}

def allowsDuration = {
    return allowsTypes(["MINUTE", "HOURLY", "DAILY", "WEEKLY", "MONTHLY", "ONCE"])
}


def _addopt = { optstring, value ->
    if (value) {
        cmdArgs << "/" + optstring << value;
    }
}

def addopt = { optstring, value, selector ->
    if (selector != null) {
        if (selector()) {
            _addopt(optstring, value);
        }
    }
    else {
        _addopt(optstring, value);
    }
}

_addopt("TN", taskName);
_addopt("TR", taskRun);
_addopt("SC", scheduleType);
addopt("MO", modifier, allowsMO);
addopt("M", month, allowsMonth);
addopt("D", day, allowsDay);


addopt("I", idletime, onidle);
addopt("ST", starttime, allowsDuration);
addopt("DU", duration, allowsDuration);
addopt("SD", startdate, allowsTimes);
addopt("ED", enddate, allowsTimes);

ch.runCommand("Creating Schedule", cmdArgs);
