/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.schema_migration;

import com.urbancode.air.plugin_command.schema_migration.SchemaValidationException;
import com.urbancode.air.plugin_command.schema_migration.SchemaVersionDocTranslator;
import com.urbancode.air.plugin_command.schema_migration.SchemaVersionDocValidator;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;

public abstract class SchemaVersionDescriptor {
    private SchemaVersionDescriptor prev;
    private SchemaVersionDescriptor next;

    public abstract int getVersion();

    public abstract String getNamespaceUrl();

    public abstract SchemaVersionDocValidator getDocValidator();

    public abstract SchemaVersionDocTranslator getDocVersionTranslator();

    protected void setNext(SchemaVersionDescriptor descriptor) {
        this.next = descriptor;
    }

    public SchemaVersionDescriptor getNext() {
        return this.next;
    }

    protected void setPrev(SchemaVersionDescriptor descriptor) {
        this.prev = descriptor;
    }

    public SchemaVersionDescriptor getPrev() {
        return this.prev;
    }

    public void translateDoc(Document doc) throws XPathExpressionException, DOMException, SchemaValidationException {
        String docNamespaceUrl = doc.getDocumentElement().getAttribute("xmlns");
        if (docNamespaceUrl == null) {
            throw new NullPointerException("Document is missing a namespace");
        }
        if (!docNamespaceUrl.equals(this.getNamespaceUrl())) {
            if (this.prev != null) {
                this.prev.translateDoc(doc);
                this.getDocVersionTranslator().transform(doc);
            } else {
                throw new IllegalArgumentException("Document namespace '" + docNamespaceUrl + "' does not match the only schema version namespace '" + this.getNamespaceUrl() + "'.");
            }
        }
    }
}

