/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.properties;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyValueScope {
    private static final Logger logger = Logger.getLogger(PropertyValueScope.class);
    private PropertyValueScope parent;
    private Map<String, String> name2value = new HashMap<String, String>();

    public static <T> String toString(Map<T, T> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<T, T> e : map.entrySet()) {
            sb.append("\t");
            sb.append(e.getKey());
            sb.append("\t->\t");
            sb.append(e.getValue());
            sb.append("\n");
        }
        return sb.toString();
    }

    public PropertyValueScope(Properties props) {
        this((PropertyValueScope)null, props);
    }

    public PropertyValueScope(Map<String, String> props) {
        this(null, props);
    }

    public PropertyValueScope(PropertyValueScope parent, Properties props) {
        this.parent = parent;
        for (Object key : props.keySet()) {
            String name = (String)key;
            this.name2value.put(name, props.getProperty(name));
        }
    }

    public PropertyValueScope(PropertyValueScope parent, Map<String, String> props) {
        this.parent = parent;
        this.name2value.putAll(props);
    }

    public String get(String name) {
        String result = this.name2value.get(name);
        if (result == null && this.parent != null) {
            result = this.parent.get(name);
        }
        return result;
    }

    public Properties getCurrentProperties() {
        Properties result = new Properties();
        result.putAll(this.name2value);
        return result;
    }

    public Properties getAllProperties() {
        Properties result = null;
        result = this.parent != null ? this.parent.getAllProperties() : new Properties();
        result.putAll(this.name2value);
        return result;
    }

    public PropertyValueScope getParent() {
        return this.parent;
    }

    public void put(String key, String value) {
        this.name2value.put(key, value);
    }

    public void insertParent(PropertyValueScope newParent) {
        PropertyValueScope oldParent = this.parent;
        PropertyValueScope endOfParentChain = newParent.getEndOfChain();
        endOfParentChain.setParent(oldParent);
        this.parent = newParent;
    }

    private PropertyValueScope getEndOfChain() {
        PropertyValueScope result = this;
        int loopCount = 0;
        while (result.getParent() != null) {
            result = result.getParent();
            if (++loopCount <= 100) continue;
            logger.warn((Object)"Giving up trying to find the end of the parent chain of a PropertyValueScope.  This could mean the chain has a cycle or there was more than 100 scopes in the chain.");
            break;
        }
        return result;
    }

    public void setParent(PropertyValueScope parent) {
        this.parent = parent;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PropertyValueScope:\n");
        if (this.parent != null) {
            sb.append("\nParent: ");
            sb.append(this.parent);
        }
        return sb.toString();
    }
}

