/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.redaction.trie;

import com.urbancode.air.plugin_command.redaction.ByteString;

public final class Emit {
    private final ByteString keyword;
    private final long start;
    private final long end;

    public Emit(long start, long end, ByteString keyword) {
        this.start = start;
        this.end = end;
        this.keyword = keyword;
    }

    public ByteString getKeyword() {
        return this.keyword;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long size() {
        return this.end - this.start + 1L;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Emit) {
            Emit rhs = (Emit)o;
            return this.start == rhs.start && this.end == rhs.end;
        }
        return false;
    }

    public int hashCode() {
        int hash = 1;
        hash = 31 * hash + (int)(this.start ^ this.start >>> 32);
        hash = 31 * hash + (int)(this.end ^ this.end >>> 32);
        return hash;
    }

    public String toString() {
        return this.start + ":" + this.end + "=" + this.keyword;
    }
}

