/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.CommandHelper
import com.urbancode.air.AirPluginTool

final AirPluginTool airPluginTool = new AirPluginTool(this.args[0], this.args[1])
final Properties props = airPluginTool.getStepProperties()

def regKey = props['regKey']
def destPath = props['destPath']
def forceString = props['force']

def force = Boolean.valueOf(forceString)

println "Registry Key:\t"+regKey
println "Destination file:\t"+destPath
println "Force overwrite:\t"+force

def ch = new CommandHelper(new File('.'))
try 
{
    def args = [];
    args = ['REG', 'EXPORT', regKey, destPath]
    if (force) {
    	args << '/y'
    }
    else if (new File(destPath)?.exists()) {
        throw new RuntimeException("File exists, and 'Force File Overwrite' is not selected");
    }
    
    ch.runCommand(args.join(' '), args)
}
catch (e) {
    println e
    System.exit 1
}
