/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.redaction.trie;

import com.urbancode.air.plugin_command.redaction.ByteString;
import java.util.HashSet;
import java.util.Set;

public final class State {
    private static final State[] blankSuccess = new State[256];
    private final int depth;
    private final State rootState;
    private State[] success;
    private int successOffset;
    private State failure;
    private Set<ByteString> emits;
    private ByteString[] emitsArray;

    public State() {
        this(0);
    }

    public State(int depth) {
        this.depth = depth;
        this.rootState = depth == 0 ? this : null;
    }

    private State get(byte character) {
        if (this.success == null) {
            return null;
        }
        int i = character & 0xFF;
        if (i < this.successOffset) {
            return null;
        }
        if ((i -= this.successOffset) >= this.success.length) {
            return null;
        }
        return this.success[i];
    }

    private State nextState(byte character, boolean ignoreRootState) {
        State nextState = this.get(character);
        if (!ignoreRootState && nextState == null && this.rootState != null) {
            nextState = this.rootState;
        }
        return nextState;
    }

    public State nextState(byte character) {
        return this.nextState(character, false);
    }

    public State nextStateIgnoreRootState(byte character) {
        return this.nextState(character, true);
    }

    public State addState(ByteString keyword) {
        State state = this;
        for (int i = 0; i < keyword.length(); ++i) {
            state = state.addState(keyword.byteAt(i));
        }
        return state;
    }

    public State addState(byte character) {
        State nextState = this.nextStateIgnoreRootState(character);
        if (nextState == null) {
            nextState = new State(this.depth + 1);
            this.updateSuccess(character, nextState);
        }
        return nextState;
    }

    private void expand() {
        State[] array = this.success;
        if (array != null && array.length == 256) {
            return;
        }
        State[] temp = new State[256];
        if (array != null) {
            System.arraycopy(this.success, 0, temp, this.successOffset, array.length);
        }
        this.success = temp;
        this.successOffset = 0;
    }

    private void compress() {
        int first = 0;
        int last = -1;
        for (int i = 0; i < this.success.length; ++i) {
            if (this.success[i] == null) continue;
            if (first == 0) {
                first = i;
            }
            last = i;
        }
        int len = last - first + 1;
        if (len == 256) {
            return;
        }
        State[] temp = new State[len];
        System.arraycopy(this.success, first, temp, 0, temp.length);
        this.success = temp;
        this.successOffset = first;
    }

    void updateSuccess(byte character, State nextState) {
        int i = character & 0xFF;
        if (this.success == null) {
            this.success = new State[]{nextState};
            this.successOffset = i;
        } else {
            this.expand();
            this.success[i] = nextState;
            this.compress();
        }
    }

    public int getDepth() {
        return this.depth;
    }

    public void addEmit(ByteString keyword) {
        if (this.emits == null) {
            this.emits = new HashSet<ByteString>();
        }
        this.emitsArray = null;
        this.emits.add(keyword);
    }

    public void addEmitArray(ByteString[] emits) {
        if (emits != null) {
            for (ByteString emit : emits) {
                this.addEmit(emit);
            }
        }
    }

    public ByteString[] emits() {
        if (this.emits == null) {
            return null;
        }
        if (this.emitsArray != null) {
            return this.emitsArray;
        }
        this.emitsArray = this.emits.toArray(new ByteString[0]);
        return this.emitsArray;
    }

    public State failure() {
        return this.failure;
    }

    public void setFailure(State failState) {
        this.failure = failState;
    }

    State[] getSuccessStates() {
        if (this.success == null) {
            return blankSuccess;
        }
        return this.success;
    }

    int getSuccessStatesOffset() {
        return this.successOffset;
    }
}

