/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.runtime;

import com.urbancode.air.plugin_command.runtime.AutomationPluginRunnable;
import com.urbancode.air.plugin_command.runtime.CacheManager;
import com.urbancode.air.plugin_command.runtime.Fetcher;
import com.urbancode.air.plugin_command.runtime.PluginJavaOpts;
import com.urbancode.air.plugin_command.runtime.ShellHelper;
import com.urbancode.air.plugin_command.runtime.StepExecutionInfo;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.xml.marshall.MarshallingEngine;
import com.urbancode.shell.impersonation.ImpersonationToken;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutomationPluginRuntime {
    private static final Logger logger = Logger.getLogger(AutomationPluginRuntime.class);
    private final CacheManager cacheManager;
    private final MarshallingEngine marshallingEngine;
    private final PluginJavaOpts opts;
    private boolean displayDetailsInOutput = false;

    public AutomationPluginRuntime(Fetcher fetcher, MarshallingEngine marshallingEngine, PluginJavaOpts javaOptsFile) throws IOException {
        Check.nonNull((Object)fetcher, (String)"fetcher");
        Check.nonNull((Object)marshallingEngine, (String)"marshalling engine");
        this.cacheManager = new CacheManager(fetcher);
        this.opts = javaOptsFile;
        this.marshallingEngine = marshallingEngine;
    }

    public AutomationPluginRuntime(Fetcher fetcher, MarshallingEngine marshallingEngine) throws IOException {
        Check.nonNull((Object)fetcher, (String)"fetcher");
        Check.nonNull((Object)marshallingEngine, (String)"marshalling engine");
        this.cacheManager = new CacheManager(fetcher);
        this.opts = null;
        this.marshallingEngine = marshallingEngine;
    }

    public void abortCommand(StepExecutionInfo info) {
        ShellHelper.getInstance().abort(info);
    }

    @Deprecated
    public void executeCommand(String pluginId, Long pluginVersion, String commandName, File inputPropFile, File envPropFile, File outputPropFile, File workingDirectory, File outputLogFile, File errorLogFile, Set<String> secureValues, ImpersonationToken impToken, StepExecutionInfo info, String postProcBody) throws Exception {
        this.executeCommand(pluginId, pluginVersion, commandName, inputPropFile, envPropFile, outputPropFile, workingDirectory, outputLogFile, errorLogFile, secureValues, null, impToken, info, postProcBody);
    }

    @Deprecated
    public void executeCommand(String pluginId, Long pluginVersion, String commandName, File inputPropFile, File envPropFile, File outputPropFile, File workingDirectory, File outputLogFile, File errorLogFile, Set<String> secureValues, Set<String> propertyNamesToKeepEnvVarsIn, ImpersonationToken impToken, StepExecutionInfo info, String postProcBody) throws Exception {
        AutomationPluginRunnable runner = this.getPluginRunner();
        runner = runner.withPluginId(pluginId).withPluginVersion(pluginVersion).withCommandName(commandName).withInputPropFile(inputPropFile).withEnvPropFile(envPropFile).withOutputPropFile(outputPropFile).withWorkingDirectory(workingDirectory).withOutputLog(outputLogFile).withErrorLogFile(errorLogFile).withSecureValues(secureValues).withPropertyNamesToKeepEnvVarsIn(propertyNamesToKeepEnvVarsIn).withImpersonationToken(impToken).withStepExecutionInfo(info).withPostProcessingScript(postProcBody);
        runner.run();
    }

    public AutomationPluginRunnable getPluginRunner() {
        return new AutomationPluginRunnable(this.cacheManager, this.marshallingEngine, this.opts, this.displayDetailsInOutput);
    }

    public boolean isDisplayDetailsInOutput() {
        return this.displayDetailsInOutput;
    }

    public void setDisplayDetailsInOutput(boolean displayDetailsInOutput) {
        this.displayDetailsInOutput = displayDetailsInOutput;
    }
}

