/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.runtime;

import com.urbancode.air.plugin_command.runtime.CharsetTranscoder;
import com.urbancode.air.plugin_command.runtime.Fetcher;
import com.urbancode.air.plugin_command.runtime.FetcherException;
import com.urbancode.air.plugin_command.runtime.HttpConnectionSettings;
import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;
import com.urbancode.commons.util.IO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;

public class FetcherHttp
extends Fetcher {
    private static final Logger logger = Logger.getLogger(FetcherHttp.class);
    private static final String restUrl = "/plugins/";
    private static final int MAX_DOWNLOAD_TRIES = Integer.getInteger("com.urbancode.air.plugin.command.runtime.FetcherHttp.numTries", 5);
    private HttpConnectionSettings settings = null;
    private HttpClient httpClient = null;

    public FetcherHttp(File storageDir, HttpClient client) {
        super(storageDir);
        this.httpClient = client;
    }

    @Deprecated
    public FetcherHttp(File storageDir) {
        super(storageDir);
    }

    public FetcherHttp setHttpConnectionSettings(HttpConnectionSettings settings) {
        this.settings = settings;
        return this;
    }

    private String getFileUrl(String id, Long version) {
        return this.getBaseUrl(id, version) + ".zip";
    }

    private String getHashUrl(String id, Long version) {
        return this.getBaseUrl(id, version) + ".hash";
    }

    private String getBaseUrl(String id, Long version) {
        String path = this.settings.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path + restUrl + id + "_" + version;
    }

    private HttpClient getHttpClient() {
        HttpClient result = null;
        if (this.httpClient != null) {
            result = this.httpClient;
            boolean shouldProxy = this.settings.shouldProxy();
            if (shouldProxy) {
                String proxyHost = this.settings.getProxyHost();
                int proxyPort = this.settings.getProxyPort();
                logger.info((Object)("Connecting through proxy " + proxyHost + ":" + proxyPort));
                HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                result.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            }
        } else {
            result = new DefaultHttpClient();
            HttpClientBuilder builder = new HttpClientBuilder();
            boolean verifyServerIdentity = Boolean.getBoolean("verify.server.identity");
            builder.setTrustAllCerts(!verifyServerIdentity);
            builder.setProxyHost(this.settings.getProxyHost());
            builder.setProxyPort(this.settings.getProxyPort());
            builder.setProxyUsername(this.settings.getProxyUserName());
            builder.setProxyPassword(this.settings.getProxyPassword());
            result = builder.buildClient();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpHost createHostConfiguration() {
        HttpConnectionSettings httpConnectionSettings = this.settings;
        synchronized (httpConnectionSettings) {
            String scheme = this.settings.getScheme();
            String hostName = this.settings.getHostName();
            int port = this.settings.getPort();
            HttpHost host = new HttpHost(hostName, port, scheme);
            logger.info((Object)("Connecting to host: " + host.toURI()));
            return host;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File fetch(String pluginId, Long version, String hash) throws FetcherException {
        if (pluginId == null) {
            logger.error((Object)"No pluginId was given to fetch().");
            throw new NullPointerException("No pluginId was given to fetch().");
        }
        if (version == null) {
            logger.error((Object)"No version was given to fetch().");
            throw new NullPointerException("No version was given to fetch().");
        }
        if (hash == null) {
            logger.error((Object)"No hash was given to fetch().");
            throw new NullPointerException("No hash was given to fetch().");
        }
        if (this.settings == null) {
            logger.error((Object)"No HttpConnectionSettings was set in the FetcherHttp.");
            throw new IllegalStateException("No HttpConnectionSettings was set in the FetcherHttp.");
        }
        String prefix = pluginId + "_" + version.toString();
        File tmpZip = null;
        File tmpDir = null;
        File resultDir = new File(this.storageDir, prefix + "_" + hash);
        try {
            try {
                tmpZip = File.createTempFile(prefix + "_", ".zip.tmp", this.storageDir).getAbsoluteFile();
                tmpDir = File.createTempFile(prefix + "_", "_tmp", this.storageDir).getAbsoluteFile();
                tmpDir.delete();
                tmpDir.mkdir();
            }
            catch (IOException e) {
                throw new FetcherException("Failed to create temporary files", e);
            }
            logger.info((Object)("Downloading Plugin to: " + tmpZip.getAbsolutePath()));
            String fileUrl = this.getFileUrl(pluginId, version);
            HttpHost host = this.createHostConfiguration();
            HttpGet method = new HttpGet(fileUrl);
            try {
                HttpResponse response = this.executeGetMethod(host, method);
                File parentDirectory = tmpZip.getCanonicalFile().getParentFile();
                if (!parentDirectory.exists() && !parentDirectory.mkdirs()) {
                    logger.error((Object)("Could not create directory " + parentDirectory.getAbsolutePath()));
                }
                InputStream dataStream = response.getEntity().getContent();
                IO.copy((InputStream)dataStream, (File)tmpZip);
                dataStream.close();
                this.verifyDigest(tmpZip, hash);
            }
            catch (Exception e) {
                throw new FetcherException("Error downloading plugin from " + host.toURI() + fileUrl, e);
            }
            finally {
                method.releaseConnection();
            }
            try {
                logger.info((Object)("Extracting Plugin zip: " + tmpZip + " to: " + tmpDir));
                IO.unzip((File)tmpZip, (File)tmpDir);
            }
            catch (IOException e) {
                throw new FetcherException("Failed to extract Plugin zip file '" + tmpZip + "'.", e);
            }
            try {
                new CharsetTranscoder(tmpDir).transcode();
            }
            catch (IOException e) {
                throw new FetcherException("Failed to transcode a file");
            }
            try {
                logger.info((Object)("Finalizing Plugin directory: " + tmpDir + " to: " + resultDir));
                IO.move((File)tmpDir, (File)resultDir);
            }
            catch (IOException e) {
                throw new FetcherException("Failed to finalize Plugin directory '" + tmpDir + "'.", e);
            }
        }
        catch (Throwable throwable) {
            try {
                this.delete(tmpZip);
            }
            catch (IOException e) {
                logger.error((Object)("Could not clean up failed download of " + pluginId + " to " + tmpZip), (Throwable)e);
            }
            try {
                this.delete(tmpDir);
            }
            catch (IOException e) {
                logger.error((Object)("Could not clean up failed extraction of " + pluginId + " to " + tmpDir), (Throwable)e);
            }
            throw throwable;
        }
        try {
            this.delete(tmpZip);
        }
        catch (IOException e) {
            logger.error((Object)("Could not clean up failed download of " + pluginId + " to " + tmpZip), (Throwable)e);
        }
        try {
            this.delete(tmpDir);
        }
        catch (IOException e) {
            logger.error((Object)("Could not clean up failed extraction of " + pluginId + " to " + tmpDir), (Throwable)e);
        }
        return resultDir;
    }

    protected String getHash(String id, Long version) throws FetcherException {
        if (id == null) {
            logger.error((Object)"No id was given to getHash().");
            throw new NullPointerException("No id was given to getHash().");
        }
        if (version == null) {
            logger.error((Object)"No version was given to getHash().");
            throw new NullPointerException("No version was given to getHash().");
        }
        if (this.settings == null) {
            logger.error((Object)"No HttpConnectionSettings was set in the FetcherHttp.");
            throw new IllegalStateException("No HttpConnectionSettings was set in the FetcherHttp.");
        }
        String result = null;
        String hashUrl = this.getHashUrl(id, version);
        HttpHost host = this.createHostConfiguration();
        HttpGet method = new HttpGet(hashUrl);
        try {
            HttpResponse response = this.executeGetMethod(host, method);
            result = IO.readText((InputStream)response.getEntity().getContent());
        }
        catch (Exception e) {
            throw new FetcherException("Error downloading plugin hash from " + host.toURI() + hashUrl, e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        if (result == null || result.length() == 0) {
            throw new FetcherException("Could not find hash for Plugin ID '" + id + "' and version '" + version + "' at " + hashUrl);
        }
        logger.trace((Object)("Found hash: " + result));
        return result;
    }

    private HttpResponse executeGetMethod(HttpHost hostConfig, HttpGet method) throws IOException {
        HttpResponse response = null;
        int numTries = 0;
        boolean retry = true;
        while (retry) {
            try {
                ++numTries;
                if (logger.isDebugEnabled()) {
                    String path = method.getURI().getPath();
                    logger.debug((Object)("Trying to get from server " + path + ". Try #:" + numTries));
                }
                response = this.getHttpClient().execute(hostConfig, (HttpRequest)method);
                retry = false;
            }
            catch (IOException e) {
                if (numTries < MAX_DOWNLOAD_TRIES) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Error retrieving plugin hash.", (Throwable)e);
                }
                throw e;
            }
        }
        int statusCode = response.getStatusLine().getStatusCode();
        String reason = response.getStatusLine().getReasonPhrase();
        switch (statusCode) {
            case 200: {
                break;
            }
            case 401: {
                throw new IOException("Unauthorized access.");
            }
            case 404: {
                throw new RuntimeException("404 Not Found: " + String.valueOf(method.getURI()));
            }
            case 403: {
                throw new RuntimeException(reason);
            }
            case 500: {
                InputStream content = response.getEntity().getContent();
                throw new IOException(reason + ": " + IO.readText((InputStream)content));
            }
            default: {
                throw new RuntimeException(reason);
            }
        }
        return response;
    }

    private void delete(File f) throws IOException {
        if (f != null) {
            IO.delete((File)f);
        }
    }

    private void verifyDigest(File f, String hexDigest) throws IOException, FetcherException {
        MessageDigest digest = IO.sha256Digester();
        IO.digest((File)f, (MessageDigest)digest);
        byte[] digestBytes = digest.digest();
        String digestString = this.toHex(digestBytes);
        if (!digestString.equalsIgnoreCase(hexDigest)) {
            throw new FetcherException("Error downloading plugin " + f + " - expected digest " + hexDigest + ", actual digest " + digestString);
        }
        logger.info((Object)("Verified hash: " + digestString + " of " + f.getAbsolutePath()));
    }

    private String toHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }
}

