/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.runtime;

import com.urbancode.air.plugin_command.runtime.CacheManager;
import com.urbancode.air.plugin_command.runtime.FetcherException;
import com.urbancode.air.plugin_command.runtime.ShellHelper;
import com.urbancode.commons.util.IO;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public class CacheEntry {
    private static final Logger log = Logger.getLogger(CacheEntry.class);
    private final String id;
    private final Long version;
    private final String hash;
    private final CacheManager manager;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private File cacheDir;

    public CacheEntry(CacheManager manager, String id, Long version, String hash) {
        this.manager = manager;
        this.id = id;
        this.version = version;
        this.hash = hash;
    }

    public File getCacheBase() {
        return this.cacheDir;
    }

    protected void setCacheBase(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    public boolean inUse() {
        return this.lock.getQueueLength() + this.lock.getReadLockCount() + this.lock.getWriteHoldCount() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReentrantReadWriteLock lock() throws FetcherException {
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            File pluginXml;
            boolean initCache = false;
            boolean rebuildCache = false;
            if (this.cacheDir == null) {
                initCache = true;
            } else if (!this.cacheDir.exists()) {
                initCache = true;
            } else {
                pluginXml = new File(this.cacheDir, "plugin.xml");
                if (!pluginXml.exists()) {
                    rebuildCache = true;
                }
            }
            if (initCache || rebuildCache) {
                this.lock.writeLock().lock();
                if (rebuildCache && !(pluginXml = new File(this.cacheDir, "plugin.xml")).exists()) {
                    log.warn((Object)("Found corrupt plugin cache directory " + this.cacheDir));
                    String deleteName = this.cacheDir.getName() + "." + UUID.randomUUID() + ".delete";
                    File deleteDir = new File(this.cacheDir.getParentFile(), deleteName);
                    try {
                        IO.move((File)this.cacheDir, (File)deleteDir);
                    }
                    catch (IOException e) {
                        throw new FetcherException("Failed to remove corrupt plugin cache directory " + this.cacheDir, e);
                    }
                }
                this.manager.cleanup(this.id, this.version, this.hash);
                this.cacheDir = this.manager.fetch(this.id, this.version, this.hash);
                this.chmodPluginDirectory();
                this.lock.writeLock().unlock();
            }
        }
        this.lock.readLock().lock();
        return this.lock;
    }

    private void chmodPluginDirectory() {
        ShellHelper.getInstance().chmodDirectory(this.cacheDir, "xr");
    }

    public ReentrantReadWriteLock unlock() {
        this.lock.readLock().unlock();
        return this.lock;
    }

    public String toString() {
        return "CacheEntry(" + this.id + ", " + this.version + ", " + this.hash + ", " + this.cacheDir + ")";
    }
}

