/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.xml;

import com.urbancode.air.plugin_command.AutomationPlugin;
import com.urbancode.commons.xml.DOMUtils;
import com.urbancode.commons.xml.marshall.MarshallingContext;
import com.urbancode.commons.xml.marshall.MarshallingRuntimeException;
import com.urbancode.commons.xml.marshall.XmlMarshallerBase;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class HeaderXmlMarshaller
extends XmlMarshallerBase {
    public static final String HEADER_ELEMENT = "header";
    public static final String HEADER_IDENTIFIER_ELEMENT = "identifier";
    public static final String IDENTIFIER_ID_ATTRIBUTE = "id";
    public static final String IDENTIFIER_NAME_ATTRIBUTE = "name";
    public static final String IDENTIFIER_VERSION_ATTRIBUTE = "version";
    public static final String HEADER_DESCRIPTION_ELEMENT = "description";
    public static final String HEADER_TAG_ELEMENT = "tag";
    private static final Logger logger = Logger.getLogger(HeaderXmlMarshaller.class);

    public HeaderXmlMarshaller() {
        super(HEADER_ELEMENT);
    }

    public void unmarshall(Element element, MarshallingContext context) throws MarshallingRuntimeException {
        logger.trace((Object)("Unmarshalling '" + element.getNodeName() + "'."));
        Element identifierElement = DOMUtils.getFirstChild((Element)element, (String)HEADER_IDENTIFIER_ELEMENT);
        String id = DOMUtils.getAttribute((Element)identifierElement, (String)IDENTIFIER_ID_ATTRIBUTE);
        String name = DOMUtils.getAttribute((Element)identifierElement, (String)IDENTIFIER_NAME_ATTRIBUTE);
        Long version = Long.valueOf(DOMUtils.getAttribute((Element)identifierElement, (String)IDENTIFIER_VERSION_ATTRIBUTE));
        String description = DOMUtils.getFirstChildText((Element)element, (String)HEADER_DESCRIPTION_ELEMENT);
        String tag = DOMUtils.getFirstChildText((Element)element, (String)HEADER_TAG_ELEMENT);
        Object obj = context.get();
        AutomationPlugin plugin = null;
        if (obj instanceof AutomationPlugin) {
            plugin = (AutomationPlugin)obj;
            plugin.setId(id);
            plugin.setName(name);
            plugin.setVersion(version);
            plugin.setDescription(description);
            plugin.setTag(tag);
        } else {
            plugin = new AutomationPlugin(id, name, version, description, tag);
        }
        context.push((Object)plugin);
    }
}

