/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.CommandHelper
import com.urbancode.air.AirPluginTool

final AirPluginTool airPluginTool = new AirPluginTool(this.args[0], this.args[1])
final Properties props = airPluginTool.getStepProperties()

def enableRemote = props['enableRemote'];
def authLevel = props['authLevel'];
def impersonLevel = props['impersonLevel']
def key = 'HKLM\\SOFTWARE\\Microsoft\\Ole\\'


def ch = new CommandHelper(new File('.'));
try 
{
    def args = [];
    if (enableRemote.toBoolean()) {
    	args = ['REG', 'ADD', key, '/v', 'EnableDCOM', '/t', 'REG_SZ', '/d', 'Y', '/f' ];
    }

    else {
    	args = ['REG', 'ADD', key, '/v', 'EnableDCOM', '/t', 'REG_SZ', '/d', 'N', '/f'];
    }

    ch.runCommand(args.join(' '), args);

    authargs = ['REG', 'ADD', key,  '/v', 'LegacyAuthenticationLevel', '/t', 'REG_DWORD', '/d', authLevel, '/f'];

    ch.runCommand(authargs.join(' '), authargs);

    impersonargs = ['REG', 'ADD', key,  '/v', 'LegacyImpersonationLevel',  '/t', 'REG_DWORD', '/d', impersonLevel, '/f'];

    ch.runCommand(impersonargs.join(' '), impersonargs);


}

catch (e) {
    println e
    System.exit 1
}
