/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.redaction;

import com.urbancode.air.plugin_command.redaction.ACRedactingOutputStream;
import com.urbancode.air.plugin_command.redaction.AbstractACRedactorBuilder;
import com.urbancode.air.plugin_command.redaction.ByteString;
import com.urbancode.air.plugin_command.redaction.trie.Trie;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ACRedactor {
    private final Trie trie;
    private final byte[] redactToken;

    public static Builder builder() {
        return new Builder();
    }

    static byte[] toBytes(String s) {
        ByteBuffer bb = ByteBuffer.allocate(s.length() * 2);
        bb.asCharBuffer().put(s);
        return bb.array();
    }

    static String toString(byte[] bs) {
        if ((bs.length & 0xFFFFFFFE) != bs.length) {
            throw new IllegalArgumentException("byte array length not even");
        }
        char[] cs = new char[bs.length / 2];
        ByteBuffer bb = ByteBuffer.wrap(bs);
        bb.asCharBuffer().get(cs);
        return new String(cs);
    }

    ACRedactor(Trie trie, String redactToken) {
        this.trie = trie;
        this.redactToken = ACRedactor.toBytes(redactToken);
    }

    public String redact(String s) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ACRedactingOutputStream rout = new ACRedactingOutputStream(this.trie, bout, this.redactToken);
            rout.write(ACRedactor.toBytes(s));
            rout.close();
            return ACRedactor.toString(bout.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected IOException", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    extends AbstractACRedactorBuilder<Builder> {
        Builder() {
        }

        public ACRedactor build() {
            return new ACRedactor(this.buildTrie(), this.redactToken);
        }

        @Override
        protected void addSecret(Trie.TrieBuilder builder, String secret) {
            builder.addKeyword(new ByteString(-1, ACRedactor.toBytes(secret)));
        }
    }
}

