/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.runtime;

import com.urbancode.air.plugin_command.runtime.CharsetTranscoder;
import com.urbancode.air.plugin_command.runtime.Fetcher;
import com.urbancode.air.plugin_command.runtime.FetcherException;
import com.urbancode.air.plugin_command.runtime.HttpConnectionSettings;
import com.urbancode.air.plugin_command.runtime.ProxyListener;
import com.urbancode.air.plugin_command.runtime.RetriableException;
import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder2;
import com.urbancode.commons.util.IO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Random;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.log4j.Logger;

public class FetcherHttp
extends Fetcher
implements ProxyListener {
    private static final Logger logger = Logger.getLogger(FetcherHttp.class);
    private static final String restUrl = "/plugins/";
    private static final int MAX_DOWNLOAD_TRIES = Integer.getInteger("com.urbancode.air.plugin.command.runtime.FetcherHttp.numTries", Integer.MAX_VALUE);
    private static final int MAX_RETRY_WAIT_PERIOD = Integer.getInteger("com.urbancode.air.plugin.command.runtime.FetcherHttp.maxRetryWaitPeriod", 240000);
    private static final HttpHost PROXY_NONE = new HttpHost("PROXY_NONE");
    private static final HttpHost PROXY_UNSET = new HttpHost("PROXY_UNSET");
    private HttpConnectionSettings settings;
    private HttpClient httpClient;
    private String serverHeaderName;
    private HttpHost proxy;
    private final Random rand;

    public FetcherHttp(File storageDir, HttpClient httpClient, String serverHeaderName) {
        this(storageDir, httpClient);
        this.serverHeaderName = serverHeaderName;
    }

    public FetcherHttp(File storageDir, HttpClient httpClient) {
        super(storageDir);
        this.httpClient = httpClient;
        this.rand = new Random();
        this.proxy = PROXY_UNSET;
    }

    @Deprecated
    public FetcherHttp(File storageDir) {
        super(storageDir);
        this.rand = new Random();
        this.proxy = PROXY_UNSET;
    }

    public HttpHost getProxy() {
        HttpHost proxy = this.getProxy0();
        if (proxy == PROXY_UNSET) {
            if (this.settings != null && this.settings.shouldProxy()) {
                return new HttpHost(this.settings.getProxyHost(), this.settings.getProxyPort());
            }
            return null;
        }
        if (proxy == PROXY_NONE) {
            return null;
        }
        return proxy;
    }

    protected synchronized HttpHost getProxy0() {
        return this.proxy;
    }

    public synchronized void setProxy(HttpHost proxy) {
        this.proxy = proxy == null ? PROXY_NONE : proxy;
    }

    public FetcherHttp setHttpConnectionSettings(HttpConnectionSettings settings) {
        this.settings = settings;
        return this;
    }

    private String getFileUrl(String id, Long version) {
        return this.getBaseUrl(id, version) + ".zip";
    }

    private String getHashUrl(String id, Long version) {
        return this.getBaseUrl(id, version) + ".hash";
    }

    private String getBaseUrl(String id, Long version) {
        String path = this.settings.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path + restUrl + id + "_" + version;
    }

    private synchronized HttpClient getHttpClient() {
        if (this.httpClient != null) {
            return this.httpClient;
        }
        HttpClientBuilder2 builder = new HttpClientBuilder2();
        boolean verifyServerIdentity = Boolean.getBoolean("verify.server.identity");
        builder.setTrustAllCerts(!verifyServerIdentity);
        builder.setProxyHost(this.settings.getProxyHost());
        builder.setProxyPort(this.settings.getProxyPort());
        builder.setProxyUsername(this.settings.getProxyUserName());
        builder.setProxyPassword(this.settings.getProxyPassword());
        this.httpClient = builder.buildClient();
        return this.httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpHost createHostConfiguration() {
        HttpConnectionSettings httpConnectionSettings = this.settings;
        synchronized (httpConnectionSettings) {
            String scheme = this.settings.getScheme();
            String hostName = this.settings.getHostName();
            int port = this.settings.getPort();
            HttpHost host = new HttpHost(hostName, port, scheme);
            return host;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File fetch(String pluginId, Long version, String hash) throws FetcherException {
        if (pluginId == null) {
            logger.error((Object)"No pluginId was given to fetch().");
            throw new NullPointerException("No pluginId was given to fetch().");
        }
        if (version == null) {
            logger.error((Object)"No version was given to fetch().");
            throw new NullPointerException("No version was given to fetch().");
        }
        if (hash == null) {
            logger.error((Object)"No hash was given to fetch().");
            throw new NullPointerException("No hash was given to fetch().");
        }
        if (this.settings == null) {
            logger.error((Object)"No HttpConnectionSettings was set in the FetcherHttp.");
            throw new IllegalStateException("No HttpConnectionSettings was set in the FetcherHttp.");
        }
        String prefix = pluginId + "_" + version.toString();
        File tmpZip = null;
        File tmpDir = null;
        File resultDir = new File(this.storageDir, prefix + "_" + hash);
        try {
            try {
                tmpZip = File.createTempFile(prefix + "_", ".zip.tmp", this.storageDir).getAbsoluteFile();
                tmpDir = File.createTempFile(prefix + "_", "_tmp", this.storageDir).getAbsoluteFile();
                tmpDir.delete();
                tmpDir.mkdir();
            }
            catch (IOException e) {
                throw new FetcherException("Failed to create temporary files", e);
            }
            logger.info((Object)("Downloading Plugin to: " + tmpZip.getAbsolutePath()));
            String fileUrl = this.getFileUrl(pluginId, version);
            HttpHost host = this.createHostConfiguration();
            HttpGet method = new HttpGet(fileUrl);
            try {
                HttpResponse response = this.executeGetMethod(host, method);
                File parentDirectory = tmpZip.getCanonicalFile().getParentFile();
                if (!parentDirectory.exists() && !parentDirectory.mkdirs()) {
                    logger.error((Object)("Could not create directory " + parentDirectory.getAbsolutePath()));
                }
                InputStream dataStream = response.getEntity().getContent();
                IO.copy((InputStream)dataStream, (File)tmpZip);
                dataStream.close();
                this.verifyDigest(tmpZip, hash);
            }
            catch (Exception e) {
                throw new FetcherException("Error downloading plugin from " + host.toURI() + fileUrl, e);
            }
            finally {
                method.releaseConnection();
            }
            try {
                logger.info((Object)("Extracting Plugin zip: " + tmpZip + " to: " + tmpDir));
                IO.unzip((File)tmpZip, (File)tmpDir);
            }
            catch (IOException e) {
                throw new FetcherException("Failed to extract Plugin zip file '" + tmpZip + "'.", e);
            }
            try {
                new CharsetTranscoder(tmpDir).transcode();
            }
            catch (IOException e) {
                throw new FetcherException("Failed to transcode a file");
            }
            try {
                logger.info((Object)("Finalizing Plugin directory: " + tmpDir + " to: " + resultDir));
                IO.move((File)tmpDir, (File)resultDir);
            }
            catch (IOException e) {
                throw new FetcherException("Failed to finalize Plugin directory '" + tmpDir + "'.", e);
            }
        }
        catch (Throwable throwable) {
            try {
                this.delete(tmpZip);
            }
            catch (IOException e) {
                logger.error((Object)("Could not clean up failed download of " + pluginId + " to " + tmpZip), (Throwable)e);
            }
            try {
                this.delete(tmpDir);
            }
            catch (IOException e) {
                logger.error((Object)("Could not clean up failed extraction of " + pluginId + " to " + tmpDir), (Throwable)e);
            }
            throw throwable;
        }
        try {
            this.delete(tmpZip);
        }
        catch (IOException e) {
            logger.error((Object)("Could not clean up failed download of " + pluginId + " to " + tmpZip), (Throwable)e);
        }
        try {
            this.delete(tmpDir);
        }
        catch (IOException e) {
            logger.error((Object)("Could not clean up failed extraction of " + pluginId + " to " + tmpDir), (Throwable)e);
        }
        return resultDir;
    }

    protected String getHash(String id, Long version) throws FetcherException {
        if (id == null) {
            logger.error((Object)"No id was given to getHash().");
            throw new NullPointerException("No id was given to getHash().");
        }
        if (version == null) {
            logger.error((Object)"No version was given to getHash().");
            throw new NullPointerException("No version was given to getHash().");
        }
        if (this.settings == null) {
            logger.error((Object)"No HttpConnectionSettings was set in the FetcherHttp.");
            throw new IllegalStateException("No HttpConnectionSettings was set in the FetcherHttp.");
        }
        String result = null;
        String hashUrl = this.getHashUrl(id, version);
        HttpHost host = this.createHostConfiguration();
        HttpGet method = new HttpGet(hashUrl);
        try {
            HttpResponse response = this.executeGetMethod(host, method);
            result = IO.readText((InputStream)response.getEntity().getContent());
        }
        catch (Exception e) {
            throw new FetcherException("Error downloading plugin hash from " + host.toURI() + hashUrl, e);
        }
        finally {
            method.releaseConnection();
        }
        if (result == null || result.length() == 0) {
            throw new FetcherException("Could not find hash for Plugin ID '" + id + "' and version '" + version + "' at " + hashUrl);
        }
        logger.trace((Object)("Found hash: " + result));
        return result;
    }

    private HttpResponse executeGetMethod(HttpHost hostConfig, HttpGet method) throws IOException, InterruptedException {
        HttpResponse response = null;
        int numTries = 0;
        int retryWaitPeriod = 0;
        while (true) {
            try {
                ++numTries;
                if (logger.isDebugEnabled()) {
                    String path = method.getURI().getPath();
                    logger.debug((Object)("Trying to get from server " + path + ". Try #:" + numTries));
                }
                try {
                    this.configureProxy(method);
                    response = this.getHttpClient().execute(hostConfig, (HttpRequest)method);
                }
                catch (IOException e) {
                    throw new RetriableException("Error making http call", 5000, e);
                }
                int statusCode = response.getStatusLine().getStatusCode();
                String reason = response.getStatusLine().getReasonPhrase();
                if (statusCode == 200) {
                    return response;
                }
                this.retryIfResponseNotFromUCD(response);
                switch (statusCode) {
                    case 401: {
                        throw new IOException("Unauthorized access.");
                    }
                    case 404: {
                        throw new IOException("404 Not Found: " + String.valueOf(method.getURI()));
                    }
                    case 403: {
                        throw new IOException(reason);
                    }
                    case 500: {
                        InputStream content = response.getEntity().getContent();
                        throw new IOException(reason + ": " + IO.readText((InputStream)content));
                    }
                    case 503: {
                        throw new RetriableException("Service Unavailable", 60000);
                    }
                    case 429: {
                        throw new RetriableException("Too Many Requests", 60000);
                    }
                }
                throw new IOException(reason);
            }
            catch (RetriableException e) {
                if (numTries >= MAX_DOWNLOAD_TRIES) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Error retrieving plugin hash.", (Throwable)e);
                    }
                    throw new IOException("Error retrieving file", e);
                }
                if (retryWaitPeriod == 0) {
                    retryWaitPeriod = e.getInitialDelay();
                }
                Thread.sleep(this.rand.nextInt(retryWaitPeriod));
                retryWaitPeriod = Math.min(MAX_RETRY_WAIT_PERIOD, retryWaitPeriod << 1);
                continue;
            }
            break;
        }
    }

    private void retryIfResponseNotFromUCD(HttpResponse response) throws RetriableException {
        Header serverContacted;
        if (!(this.serverHeaderName == null || (serverContacted = response.getFirstHeader(this.serverHeaderName)) != null && serverContacted.getValue().equals("true"))) {
            throw new RetriableException("Could not reach server to download plugin", 5000);
        }
    }

    private void delete(File f) throws IOException {
        if (f != null) {
            IO.delete((File)f);
        }
    }

    private void verifyDigest(File f, String hexDigest) throws IOException, FetcherException {
        MessageDigest digest = IO.sha256Digester();
        IO.digest((File)f, (MessageDigest)digest);
        byte[] digestBytes = digest.digest();
        String digestString = this.toHex(digestBytes);
        if (!digestString.equalsIgnoreCase(hexDigest)) {
            throw new FetcherException("Error downloading plugin " + f + " - expected digest " + hexDigest + ", actual digest " + digestString);
        }
        logger.info((Object)("Verified hash: " + digestString + " of " + f.getAbsolutePath()));
    }

    private String toHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }

    private void configureProxy(HttpGet req) {
        HttpHost proxy = this.getProxy();
        if (proxy != null) {
            RequestConfig config = req.getConfig();
            RequestConfig.Builder configBuilder = config != null ? RequestConfig.copy((RequestConfig)config) : RequestConfig.custom();
            configBuilder.setProxy(proxy);
            req.setConfig(configBuilder.build());
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Connecting through proxy " + proxy.getHostName() + ":" + proxy.getPort()));
            }
        }
    }
}

