/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.properties;

import com.urbancode.air.plugin_command.properties.PropertyValueScope;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyResolver {
    private static final Logger logger = Logger.getLogger(PropertyResolver.class);
    private static final String tokenPatternString = "[$][{]((?:[^\\\\}]++|\\\\[}]|\\\\(?![}]))*)[}]";
    private static final Pattern tokenPattern = Pattern.compile("[$][{]((?:[^\\\\}]++|\\\\[}]|\\\\(?![}]))*)[}]", 40);
    private final PropertyValueScope propertyProvider;

    public PropertyResolver(PropertyValueScope propertyProvider) {
        this.propertyProvider = propertyProvider;
    }

    public String resolve(String s) {
        return this.replaceTokens(s, new HashSet<String>());
    }

    String replaceTokens(String s, Set<String> cycleDetector) {
        Matcher matcher = tokenPattern.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String value;
            String token = matcher.group();
            String propName = this.getPropertyNameFromExpression(token);
            if (StringUtils.isNotBlank((String)propName)) {
                if (cycleDetector.add(propName)) {
                    String rawValue = this.getPropertyValue(propName);
                    value = rawValue != null ? this.replaceTokens(rawValue, cycleDetector) : (token.startsWith("${p?:") || token.startsWith("${property?:") ? "" : token);
                    cycleDetector.remove(propName);
                } else {
                    logger.warn((Object)String.format("Found a back reference during resolution of %s via %s ", token, propName));
                    value = token;
                }
            } else {
                value = token;
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(value));
        }
        matcher.appendTail(sb);
        String result = sb.toString();
        return result;
    }

    protected String getPropertyValue(String propName) {
        String result = null;
        if (propName != null && (propName = propName.trim()).length() != 0 && (result = this.propertyProvider.get(propName)) == null && propName.startsWith("env/")) {
            propName = propName.substring(4);
            result = this.propertyProvider.get(propName);
        }
        return result;
    }

    protected String getPropertyNameFromExpression(String expression) {
        String dividerString = expression.contains(":") ? ":" : "{";
        String result = expression.substring(expression.indexOf(dividerString) + 1, expression.length() - 1);
        return result.replaceAll("\\\\[}]", "}");
    }
}

