/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.properties;

import com.urbancode.air.plugin_command.properties.PluginCommandProperty;
import com.urbancode.air.plugin_command.properties.PropertyValueMissingException;
import com.urbancode.air.plugin_command.properties.PropertyValueScope;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredPropertyValidator {
    private final PropertyValueScope valueProvider;

    public RequiredPropertyValidator(PropertyValueScope valueProvider) {
        this.valueProvider = valueProvider;
    }

    public void validate(Collection<PluginCommandProperty> pluginProps) throws PropertyValueMissingException {
        PropertyValueMissingException exception = new PropertyValueMissingException();
        for (PluginCommandProperty def : pluginProps) {
            String value = this.valueProvider.get(def.getName());
            if (value != null || !def.isRequired()) continue;
            exception.addPluginPropertyWithNoValue(def);
        }
        if (exception.getListOfPluginPropertiesWithNoValues().size() > 0) {
            throw exception;
        }
    }
}

