/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.redaction;

import com.urbancode.air.plugin_command.redaction.trie.Trie;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractACRedactorBuilder<T extends AbstractACRedactorBuilder<T>> {
    protected String redactToken = "****";
    protected Set<String> knownSecrets = new HashSet<String>();

    AbstractACRedactorBuilder() {
    }

    public T addSecret(String secret) {
        if (secret != null && secret.length() != 0) {
            this.knownSecrets.add(secret);
        }
        return this.self();
    }

    public T addSecrets(Collection<String> secrets) {
        for (String s : secrets) {
            this.addSecret(s);
        }
        return this.self();
    }

    public T setRedactToken(String redactToken) {
        redactToken.getClass();
        this.redactToken = redactToken;
        return this.self();
    }

    protected T self() {
        return (T)this;
    }

    protected Trie buildTrie() {
        Trie.TrieBuilder tb = Trie.builder();
        for (String s : this.knownSecrets) {
            this.addSecret(tb, s);
        }
        return tb.build();
    }

    protected abstract void addSecret(Trie.TrieBuilder var1, String var2);
}

