/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.runtime;

import com.urbancode.air.plugin_command.runtime.CacheManager;
import com.urbancode.air.plugin_command.runtime.FetcherException;
import com.urbancode.air.plugin_command.runtime.FileFactory;
import com.urbancode.air.plugin_command.runtime.ShellHelper;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public class CacheEntry {
    private static final Logger log = Logger.getLogger(CacheEntry.class);
    private final String id;
    private final Long version;
    private final String hash;
    private final CacheManager manager;
    private final FileFactory fileFactory;
    private final ShellHelper shellHelper;
    private final ReentrantReadWriteLock lock;
    private File cacheDir;

    public CacheEntry(CacheManager manager, String id, Long version, String hash) {
        this(manager, id, version, hash, new FileFactory(), ShellHelper.getInstance(), new ReentrantReadWriteLock());
    }

    CacheEntry(CacheManager manager, String id, Long version, String hash, FileFactory fileFactory, ShellHelper shellHelper, ReentrantReadWriteLock lock) {
        this.manager = manager;
        this.id = id;
        this.version = version;
        this.hash = hash;
        this.fileFactory = fileFactory;
        this.shellHelper = shellHelper;
        this.lock = lock;
    }

    public synchronized File getCacheBase() {
        return this.cacheDir;
    }

    protected synchronized void setCacheBase(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    public boolean inUse() {
        return this.lock.getQueueLength() + this.lock.getReadLockCount() + this.lock.getWriteHoldCount() > 0;
    }

    protected synchronized ReentrantReadWriteLock lock() throws FetcherException {
        boolean initCache = this.needToInitCache();
        boolean rebuildCache = this.needToRebuildCache(initCache);
        if (initCache || rebuildCache) {
            this.lock.writeLock().lock();
            try {
                this.initOrRebuildCache(rebuildCache);
                this.lock.readLock().lock();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        } else {
            this.lock.readLock().lock();
        }
        return this.lock;
    }

    private boolean needToInitCache() {
        if (this.cacheDir == null) {
            return true;
        }
        return !this.cacheDir.exists();
    }

    private boolean needToRebuildCache(boolean needToInitCache) {
        File pluginXml;
        return !needToInitCache && !(pluginXml = this.fileFactory.newFile(this.cacheDir, "plugin.xml")).exists();
    }

    private void chmodPluginDirectory() {
        this.shellHelper.chmodDirectory(this.cacheDir, "xr");
    }

    public ReentrantReadWriteLock unlock() {
        this.lock.readLock().unlock();
        return this.lock;
    }

    public String toString() {
        return "CacheEntry(" + this.id + ", " + this.version + ", " + this.hash + ", " + this.cacheDir + ")";
    }

    private void initOrRebuildCache(boolean rebuildCache) throws FetcherException {
        File pluginXml;
        if (rebuildCache && !(pluginXml = this.fileFactory.newFile(this.cacheDir, "plugin.xml")).exists()) {
            log.warn((Object)("Found corrupt plugin cache directory " + this.cacheDir));
            String deleteName = this.cacheDir.getName() + "." + UUID.randomUUID() + ".delete";
            File deleteDir = this.fileFactory.newFile(this.cacheDir.getParentFile(), deleteName);
            try {
                this.fileFactory.move(this.cacheDir, deleteDir);
            }
            catch (IOException e) {
                throw new FetcherException("Failed to remove corrupt plugin cache directory " + this.cacheDir, e);
            }
        }
        this.manager.cleanup(this.id, this.version, this.hash);
        this.cacheDir = this.manager.fetch(this.id, this.version, this.hash);
        this.chmodPluginDirectory();
    }
}

