/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.runtime;

import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class StepExecutionInfo {
    static final int NOT_STARTED = 0;
    static final int STARTED = 1;
    static final int TERMINATING = 2;
    static final int TERMINATED = 3;
    private static final int STATE_MASK = 3;
    private static final int ABORTED = 4;
    private static final AtomicIntegerFieldUpdater<StepExecutionInfo> state0Updater = AtomicIntegerFieldUpdater.newUpdater(StepExecutionInfo.class, "state0");
    private final UUID id;
    private final CountDownLatch done;
    private volatile int state0;

    public StepExecutionInfo(UUID uuid) {
        this(uuid, new CountDownLatch(1));
    }

    StepExecutionInfo(UUID id, CountDownLatch done) {
        this.id = id;
        this.id.getClass();
        this.done = done;
        this.done.getClass();
    }

    public void abort() {
        this.startTermination();
    }

    public boolean isAborted() {
        return this.decodeAborted(this.getState0()) != 0;
    }

    public UUID getId() {
        return this.id;
    }

    public void awaitTermination() throws InterruptedException {
        this.done.await();
    }

    public boolean startRun() {
        int state0;
        block6: while (true) {
            state0 = this.getState0();
            switch (this.decodeState(state0)) {
                case 0: {
                    if (!this.compareAndSetState0(state0, 1)) continue block6;
                    return true;
                }
                case 1: {
                    throw new IllegalStateException("already started");
                }
                case 2: {
                    throw new IllegalStateException("already terminating");
                }
                case 3: {
                    return false;
                }
            }
            break;
        }
        throw new RuntimeException("unimplemented state: " + state0);
    }

    public void endRun() {
        int state0;
        block5: while (true) {
            state0 = this.getState0();
            switch (this.decodeState(state0)) {
                case 0: {
                    throw new IllegalStateException("not started");
                }
                case 1: 
                case 2: {
                    if (!this.compareAndSetState0(state0, this.encodeState(state0, 3))) continue block5;
                    this.done.countDown();
                    return;
                }
                case 3: {
                    return;
                }
            }
            break;
        }
        throw new RuntimeException("unimplemented state: " + state0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void startTermination() {
        int state0;
        block5: while (true) {
            state0 = this.getState0();
            switch (this.decodeState(state0)) {
                case 0: {
                    if (!this.compareAndSetState0(state0, this.encode(state0, 3, true))) continue block5;
                    this.done.countDown();
                    return;
                }
                case 1: {
                    if (!this.compareAndSetState0(state0, this.encode(state0, 2, true))) continue block5;
                    return;
                }
                case 2: 
                case 3: {
                    if (this.compareAndSetState0(state0, this.encodeAborted(state0, true))) return;
                    continue block5;
                }
            }
            break;
        }
        throw new RuntimeException("unimplemented state: " + state0);
    }

    int getState() {
        return this.getState0() & 3;
    }

    private int encode(int state0, int state, boolean aborted) {
        return this.encodeAborted(this.encodeState(state0, state), aborted);
    }

    private int decodeState(int state0) {
        return state0 & 3;
    }

    private int decodeAborted(int state0) {
        return state0 & 4;
    }

    private int encodeAborted(int state0, boolean aborted) {
        if (aborted) {
            return state0 | 4;
        }
        return state0 & 0xFFFFFFFB;
    }

    private int encodeState(int state0, int state) {
        return state0 & 0xFFFFFFFC | state & 3;
    }

    private int getState0() {
        return state0Updater.get(this);
    }

    private boolean compareAndSetState0(int oldVal, int newVal) {
        return state0Updater.compareAndSet(this, oldVal, newVal);
    }
}

