/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.CommandHelper
import com.urbancode.air.AirPluginTool

final AirPluginTool airPluginTool = new AirPluginTool(this.args[0], this.args[1])
final Properties props = airPluginTool.getStepProperties()

def regKey = props['regKey'];
def regType = props['regType'];
def regName = props['regName'];
def regData = props['regData'];
def forceString = props['force']
def force = Boolean.valueOf(forceString)
def ch = new CommandHelper(new File('.'));

def keyFound = true;
def args = [];
    
try {
    args = ['REG', 'QUERY', regKey, '/v', regName];
    ch.runCommand(args.join(' '), args);
}
catch (e) {
    //registry key was not found
    keyFound = false
}

try 
{
    if (!keyFound || force) {
        args = ['REG', 'ADD', regKey, '/v', regName, '/t', regType, '/d', regData];
        if (force) {
        	args << '/f'
        }
        
        ch.runCommand(args.join(' '), args);
    }
    else {
        //the key was found and we're not overwriting it
        throw new RuntimeException("The key already exists and overwrite was not enabled");
    }
}

catch (e) {
    println e
    System.exit 1
}
