#!/usr/bin/env groovy
/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;

def workDir = new File('.').canonicalFile;
def ch      = new CommandHelper(workDir);
def airTool = new AirPluginTool(args[0], args[1]);
final def props = airTool.stepProperties;

def taskName       = props['taskName'];
def taskRun        = props['taskRun'];
def scheduleType   = props['scheduleType'];
def modifier       = props['modifier'];
def month          = props['month'];
def day            = props['day'];
def idletime       = props['idletime'];
def starttime      = props['starttime'];
def duration       = props['duration'];
def startdate      = props['startdate'];
def enddate        = props['enddate'];
def username       = props['username'];
def password       = props['password'];
def usernameRU     = props['usernameRU'];
def passwordRP     = props['passwordRP'];
def additionalArgs = props['additionalArgs'];


def command = 'schtasks';
def subcommand = '/create';
def cmdArgs = [command, subcommand];

def allowsTypes = { vals ->
    return vals.contains(scheduleType);
}

def allowsMO = {
    return allowsTypes(["MINUTE", "HOURLY","DAILY", "WEEKLY", "MONTHLY", "ONEVENT"]);
}

def allowsMonth = {
    return allowsTypes(["MONTHLY"]);
}

def allowsDay = {
   return allowsTypes(["MONTHLY", "WEEKLY"]);
}

def onidle = {
    return allowsTypes(["ONIDLE"]);
}


def allowsInterval = {
    return allowsTypes(["DAILY", "WEEKLY", "MONTHLY", "ONCE"]);
}

def allowsTimes = {
    return allowsTypes(["MINUTE", "HOURLY", "DAILY", "WEEKLY", "MONTHLY"]);
}

def allowsDuration = {
    return allowsTypes(["MINUTE", "HOURLY", "DAILY", "WEEKLY", "MONTHLY", "ONCE"]);
}


def addoptNoValue = { optstring ->
    if (optstring) {
        cmdArgs << "/" + optstring;
    }
}

def _addopt = { optstring, value ->
    if (value) {
        cmdArgs << "/" + optstring << value;
    }
}

def addopt = { optstring, value, selector ->
    if (selector != null) {
        if (selector()) {
            _addopt(optstring, value);
        }
    }
    else {
        _addopt(optstring, value);
    }
}

_addopt("TN", taskName);
_addopt("TR", taskRun);
_addopt("SC", scheduleType);
addopt("MO", modifier, allowsMO);
addopt("M", month, allowsMonth);
addopt("D", day, allowsDay);


addopt("I", idletime, onidle);
addopt("ST", starttime, allowsDuration);
addopt("DU", duration, allowsDuration);
addopt("SD", startdate, allowsTimes);
addopt("ED", enddate, allowsTimes);

if (username) {
    if (password) {
        _addopt("U", username);
        _addopt("P", password);
    }
    else {
        println "[Error] Both Username and Password must be given to specify the user context for Schtasks to run under.";
        System.exit(1);
    }
}

if (usernameRU) {
    if (passwordRP) {
        _addopt("RU", usernameRU);
        _addopt("RP", passwordRP);
    }
    else {
        println "[Error] Both Task Username and Task Password must be given to specify the user context for the task to run under.";
        System.exit(1);
    }
}

for (arg in additionalArgs.split("\n|,")*.trim()) {
    if (arg.indexOf("/") != 0) {
        println "[Error] Ensure your argument '${arg}' is valid. All arguments must begin with a forward slash '/'.";
        System.exit(1);
    }
    def argArray = arg.substring(1).split("\\s+", 2);
    if (argArray.size() == 2) {
        _addopt(argArray[0], argArray[1]);
    }
    else {
        addoptNoValue(argArray[0]);
    }
}

ch.runCommand("Creating Schedule", cmdArgs);
