/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2011, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
/* This is an example step groovy to show the proper use of APTool
 * In order to use import these utilities, you have to use the "pluginutilscripts" jar
 * that comes bundled with this plugin example. 
 */
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;


def apTool = new AirPluginTool(this.args[0], this.args[1]) 

def props = apTool.getStepProperties();

def commandDir = props['commandDir']
def brokerName = props['brokerName']
def projName = props['projName']
def viewPath = props['viewPath']
def workDir = new File('.');
def ch = new CommandHelper(workDir);
def state = props['state']
def packageName = props['packageName']
def username = props['username']
def password = props['password']
def useOnlyPackageVersions = Boolean.valueOf(props['useOnlyPackageVersions']);
def outFile = File.createTempFile('hco', 'out.txt');
def searchPatterns = props['searchPatterns'].split("\n");


outFile.deleteOnExit();


def hcoExe = 'hco'
if (commandDir) {
   def cmdDir = new File("commandDir");
   if (!cmdDir.isDirectory()) {
       System.out.println("Command Directory specified but either doesn't exist or isn't a directory.");
       System.exit(1);
   }
   def posExt = [ '', '.exe', '.bat', '.sh', '.cmd'] as String[];
   def hcoExeFile = null;
   for (int i = 0; i < posExe.length; i++) {
       hcoExeFile = new File(cmdDir, 'hco' + posExt[i]);
       if (hcoExeFile.isFile()) {
           break;
       }
   }

   if (!hcoExeFile.isFile()) {
       System.out.println("Command Directory doesn't contain hco executable!");
       System.exit(1);
   }
   hcoExe = hcoExeFile.absolutePath;
}
else {
   System.out.println("Command Directory not specified. Assuming hco is on path.");
}

def cmdArgs = [hcoExe, 
               '-b', 
               brokerName, 
               '-en', 
               projName, 
               '-vp', 
               viewPath, 
               '-br', 
               '-cp', 
               workDir.absolutePath, 
               '-op',
               'pc',
               '-st',
                state,
               '-o',
               outFile.absolutePath,
               '-s'
              ];

searchPatterns.each {
    if (it?.trim()) {
        cmdArgs << it.trim();
    }
}

if (packageName) {
    cmdArgs << '-pf' << packageName 
    if (useOnlyPackageVersions) {
        cmdArgs << '-po';
    }
}

cmdArgs << '-usr' << username << '-pw' << password;

def exitCode = 0;
try {
    ch.runCommand("Checking out for browsing", cmdArgs);
}
catch (Exception e) {
    System.out.println("Error checking out");
    exitCode = 1;
}
finally {
    System.out.println(outFile.text);
    outFile.delete();
}

System.exit(exitCode);
