/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.PluginExecutionException;
import com.urbancode.air.plugin.command.RTCSCMClient;
import com.urbancode.commons.util.IO;
import com.urbancode.ud.client.ComponentClient;
import com.urbancode.ud.client.VersionClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class ImportVersion {
    private static final Logger log = Logger.getLogger(ImportVersion.class);
    private Properties inputProperties;
    private Properties outputProperties;
    private String SNAPSHOT = "SNAPSHOT";
    private String STREAM = "STREAM";

    public ImportVersion(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    private String getProp(String propName) {
        return this.inputProperties.getProperty(propName);
    }

    private Boolean getBooleanProp(String propName) {
        return Boolean.valueOf(this.getProp(propName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        block10: {
            try {
                ConsoleAppender app = new ConsoleAppender();
                app.setWriter((Writer)new PrintWriter(System.out));
                PatternLayout layout = new PatternLayout("%d{ISO8601} - %m%n");
                app.setLayout((Layout)layout);
                Logger.getRootLogger().setLevel(Level.OFF);
                Logger packageLogger = Logger.getLogger((String)this.getClass().getPackage().getName());
                packageLogger.setLevel(Level.ALL);
                packageLogger.addAppender((Appender)app);
                Properties agentProps = new Properties();
                FileInputStream fiStream = null;
                try {
                    fiStream = new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/installed.properties"));
                    agentProps.load(fiStream);
                }
                catch (Throwable throwable) {
                    IO.close(fiStream);
                    throw throwable;
                }
                IO.close((InputStream)fiStream);
                String charsetName = agentProps.getProperty("system.default.encoding");
                Charset charset = null;
                if (charsetName != null) {
                    charset = Charset.forName(charsetName);
                }
                String username = "PasswordIsAuthToken";
                String password = String.format("{\"token\": \"%s\"}", System.getenv("AUTH_TOKEN"));
                String webUrl = System.getenv("AH_WEB_URL");
                URI url = new URI(webUrl);
                VersionClient versionClient = new VersionClient(url, username, password);
                ComponentClient componentClient = new ComponentClient(url, username, password);
                String componentName = this.getProp("componentName");
                Boolean isUseVFS = this.getBooleanProp("isUseVFS");
                String rtcServerUrl = this.getProp("serverUrl");
                String rtcUser = this.getProp("username");
                String rtcPass = this.getProp("password");
                String rtcStream = this.getProp("stream");
                Boolean isIncludeRoot = this.getBooleanProp("isIncludeRoot");
                String commandPath = this.getProp("commandPath");
                String workspaceHistoryType = this.getProp("workspaceHistoryType");
                if (workspaceHistoryType == null || workspaceHistoryType.length() == 0) {
                    workspaceHistoryType = "SNAPSHOT";
                }
                String autoGenerateName = this.getProp("autoGenerateName");
                String version = this.getProp("version");
                String extensionString = this.getProp("extensions");
                String[] extensions = new String[]{};
                if (extensionString != null) {
                    extensions = extensionString.split(",");
                    for (int i = 0; i < extensions.length; ++i) {
                        extensions[i] = extensions[i].trim();
                    }
                }
                RTCSCMClient rtcClient = new RTCSCMClient(rtcServerUrl, rtcUser, rtcPass, rtcStream, isIncludeRoot, commandPath, autoGenerateName);
                if (version != null && version.trim().length() > 0) {
                    UUID versionId = this.integrate(rtcClient, componentClient, versionClient, componentName, version, workspaceHistoryType, rtcStream, isUseVFS, charset, extensions);
                    this.outputProperties.put("VersionID", versionId);
                    break block10;
                }
                version = rtcClient.getLatestVersion();
                if (version != null) {
                    UUID versionId = this.integrate(rtcClient, componentClient, versionClient, componentName, version, workspaceHistoryType, rtcStream, isUseVFS, charset, extensions);
                    this.outputProperties.put("VersionID", versionId);
                    break block10;
                }
                throw new PluginExecutionException("No versions found in stream " + rtcStream + "!");
            }
            catch (Exception e) {
                log.error((Object)String.format("Error Creating New Version: %s", e.getMessage()), (Throwable)e);
                return 1;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID integrate(RTCSCMClient rtcClient, ComponentClient componentClient, VersionClient versionClient, String componentName, String version, String workspaceHistoryType, String rtcStream, boolean isUseVFS, Charset charset, String[] extensions) throws Exception {
        UUID result;
        File tempDir;
        block17: {
            tempDir = null;
            result = null;
            try {
                String includesString = this.getProp("includes");
                String excludesString = this.getProp("excludes");
                String[] includes = new String[]{"**/*"};
                if (includesString != null && includesString.trim().length() > 0) {
                    includes = includesString.split("\n");
                }
                String[] excludes = new String[]{};
                if (excludesString != null && excludesString.trim().length() > 0) {
                    excludes = excludesString.split("\n");
                }
                boolean preserveExecutePermissions = this.getBooleanProp("saveFileExecuteBits");
                List versions = componentClient.getComponentVersions(componentName, Boolean.valueOf(false));
                boolean hasVersion = versions.contains(version);
                log.info((Object)("Version from rtc: " + version));
                if (!hasVersion) {
                    log.info((Object)"Creating new version");
                    if (isUseVFS) {
                        log.info((Object)"Uploading files to VFS");
                        String[] wsFiles = new String[2];
                        if (workspaceHistoryType.equals(this.SNAPSHOT)) {
                            wsFiles[0] = "--snapshot";
                            wsFiles[1] = version;
                        } else if (workspaceHistoryType.equals(this.STREAM)) {
                            wsFiles[0] = "--stream";
                            wsFiles[1] = rtcStream;
                        } else {
                            throw new Exception("Incorrect workspace history type found!");
                        }
                        tempDir = rtcClient.downloadWorkspaceFiles(wsFiles);
                        String versionId = versionClient.createVersion(componentName, version, " ").toString();
                        versionClient.addVersionFiles(componentName, versionId, tempDir, "", includes, excludes, preserveExecutePermissions, true, charset, extensions);
                        rtcClient.cleanupFromDownload(tempDir);
                    } else {
                        String versionId = versionClient.createVersion(componentName, version, " ").toString();
                        log.info((Object)String.format("Not uploading version %s to VFS because using VFS was not selected.", versionId));
                    }
                    break block17;
                }
                log.info((Object)String.format("UCD already contains version %s. A duplicate will not be created.", version));
            }
            catch (Throwable throwable) {
                try {
                    if (tempDir != null && tempDir.exists()) {
                        IO.delete((File)tempDir);
                    }
                }
                catch (IOException e) {
                    log.error((Object)String.format("Unable to delete download directory", e.getMessage()), (Throwable)e);
                }
                throw throwable;
            }
        }
        try {
            if (tempDir != null && tempDir.exists()) {
                IO.delete((File)tempDir);
            }
        }
        catch (IOException e) {
            log.error((Object)String.format("Unable to delete download directory", e.getMessage()), (Throwable)e);
        }
        return result;
    }
}

