/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ud.client;

import com.urbancode.ud.client.UDRestClient;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.impl.client.DefaultHttpClient;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemClient
extends UDRestClient {
    public SystemClient(URI url, String clientUser, String clientPassword) {
        super(url, clientUser, clientPassword);
    }

    public SystemClient(URI url, String clientUser, String clientPassword, boolean trustAllCerts) {
        super(url, clientUser, clientPassword, trustAllCerts);
    }

    public SystemClient(URI url, DefaultHttpClient client) {
        super(url, client);
    }

    public void addUserToTeam(String user, String team, String type) throws IOException {
        String uri = this.url + "/cli/teamsecurity/users?user=" + this.encodePath(user) + "&team=" + this.encodePath(team) + "&type=" + this.encodePath(type);
        HttpPut method = new HttpPut(uri);
        this.invokeMethod(method);
    }

    public void addGroupToTeam(String group, String team, String type) throws IOException {
        String uri = this.url + "/cli/teamsecurity/groups?group=" + this.encodePath(group) + "&team=" + this.encodePath(team) + "&type=" + this.encodePath(type);
        HttpPut method = new HttpPut(uri);
        this.invokeMethod(method);
    }

    public JSONObject getSystemConfiguration() throws JSONException, IOException {
        String uri = this.url + "/cli/systemConfiguration";
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod(method);
        JSONObject result = new JSONObject(this.getBody(response));
        return result;
    }

    public void setSystemConfiguration(Map<String, String> properties) throws JSONException, IOException {
        String uri = this.url + "/cli/systemConfiguration";
        JSONObject jsonToSend = new JSONObject();
        for (String key : properties.keySet()) {
            jsonToSend.put(key, properties.get(key));
        }
        HttpPut method = new HttpPut(uri);
        method.setEntity(this.getStringEntity(jsonToSend));
        this.invokeMethod(method);
    }

    public String setSystemProperty(String name, String value, boolean isSecure) throws IOException {
        if ("".equals(name)) {
            throw new IOException("a required argument was not supplied");
        }
        String uri = this.url + "/cli/systemConfiguration/propValue?name=" + this.encodePath(name) + "&value=" + this.encodePath(value) + "&isSecure=" + this.encodePath(String.valueOf(isSecure));
        HttpPut method = new HttpPut(uri);
        this.invokeMethod(method);
        String result = isSecure ? name + "=****" : name + "=" + value;
        return result;
    }
}

