/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.xml;

import com.urbancode.commons.xml.Context;
import com.urbancode.commons.xml.DOMUtils;
import com.urbancode.commons.xml.MarshallingRuntimeException;
import com.urbancode.commons.xml.XmlMarshaller;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MarshallEngine {
    private Map name2marshaller = new HashMap();

    protected MarshallEngine() {
    }

    public void registerMarshaller(XmlMarshaller marshaller) {
        this.name2marshaller.put(marshaller.getName(), marshaller);
    }

    public void unmarshall(InputStream inStream, Context context) throws MarshallingRuntimeException {
        if (inStream != null) {
            try {
                Document doc = DOMUtils.loadDocument(inStream);
                Element rootElement = doc.getDocumentElement();
                this.unmarshall(rootElement, context);
            }
            catch (Exception e) {
                throw new MarshallingRuntimeException(e);
            }
        }
    }

    public void unmarshall(Element element, Context context) throws MarshallingRuntimeException {
        XmlMarshaller marshaller = this.getMarshaller(element);
        if (marshaller == null) {
            throw new IllegalStateException("Marshaller not registered for element: " + element.getTagName());
        }
        marshaller.unmarshall(element, context);
    }

    public void unmarshallChildElements(Element element, Context context) throws MarshallingRuntimeException {
        NodeList childNodeList = element.getChildNodes();
        Node childNode = null;
        for (int i = 0; i < childNodeList.getLength(); ++i) {
            childNode = childNodeList.item(i);
            if (childNode.getNodeType() != 1) continue;
            this.unmarshall((Element)childNode, context);
        }
    }

    public XmlMarshaller getMarshaller(Element element) {
        XmlMarshaller result = (XmlMarshaller)this.name2marshaller.get(element.getTagName());
        return result;
    }
}

