/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.concurrent.WaitFuture;
import com.urbancode.commons.util.processes.Processes;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class RTCSCMClient {
    private static final Logger log = Logger.getLogger(RTCSCMClient.class);
    private String url;
    private String username;
    private String password;
    private String stream;
    private String commandPath;
    private String autoGenerateName;
    private boolean includeRoot;
    private Map<File, UUID> wsMap = new HashMap<File, UUID>();

    public RTCSCMClient(String url, String username, String password, String stream, boolean includeRoot, String commandPath, String autoGenerateName) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.stream = stream;
        this.commandPath = commandPath;
        this.includeRoot = includeRoot;
        this.autoGenerateName = autoGenerateName;
    }

    public String getLatestVersion() throws IOException {
        String result = this.getLatestSnapshot();
        return result;
    }

    public File downloadWorkspaceFiles(String[] wsFiles) throws IOException {
        File tempDir = File.createTempFile("rtc", "scm");
        tempDir.delete();
        tempDir.mkdirs();
        UUID wsName = UUID.randomUUID();
        try {
            this.createWorkspace(wsName.toString(), wsFiles);
            this.loadWorkspace(wsName.toString(), tempDir);
            this.wsMap.put(tempDir, wsName);
        }
        catch (IOException e) {
            try {
                this.cleanupFromDownload(tempDir);
            }
            catch (Exception ie) {
                log.error((Object)"Exception cleaning up!", (Throwable)ie);
            }
            throw e;
        }
        return tempDir;
    }

    public void cleanupFromDownload(File tempDir) throws IOException {
        this.deleteWorkspace(tempDir);
    }

    private void createWorkspace(String wsName, String[] wsFiles) throws IOException {
        List<String> command = Arrays.asList(this.commandPath, "--non-interactive", "create", "workspace", wsName, wsFiles[0], wsFiles[1], "-r", this.url, "-u", this.username, "-P", this.password);
        this.runCommand(command);
    }

    private void loadWorkspace(String wsName, File tempDir) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(Arrays.asList(this.commandPath, "--non-interactive", "load", "--all", wsName, "-d", tempDir.getAbsolutePath(), "-r", this.url, "-u", this.username, "-P", this.password));
        if (this.includeRoot) {
            command.add("--include-root");
        }
        this.runCommand(command);
    }

    private void deleteWorkspace(File tempDir) throws IOException {
        String wsName = this.wsMap.get(tempDir).toString();
        List<String> command = Arrays.asList(this.commandPath, "--non-interactive", "workspace", "delete", wsName, "-r", this.url, "-u", this.username, "-P", this.password);
        this.runCommand(command);
        IO.delete(tempDir);
        this.wsMap.remove(tempDir);
    }

    private String getLatestSnapshot() throws IOException {
        String result = null;
        List<String> command = Arrays.asList(this.commandPath, "--non-interactive", "list", "snapshots", this.stream, "-r", this.url, "-u", this.username, "-P", this.password);
        StringBuilder logMess = new StringBuilder();
        logMess.append("Running command:");
        for (String elem : command) {
            logMess.append(" ");
            logMess.append(elem);
        }
        log.info((Object)logMess.toString());
        ProcessBuilder builder = new ProcessBuilder(command);
        Processes processes = new Processes();
        Process proc = builder.start();
        try {
            IO.close(proc.getOutputStream());
            Future<String> errorFuture = processes.getErrorStringFuture(proc);
            Future<String> outputFuture = processes.getOutputStringFuture(proc);
            int status = proc.waitFor();
            String output = outputFuture.get();
            if (status != 0) {
                throw new IOException("SCM error: " + errorFuture.get());
            }
            BufferedReader read = new BufferedReader(new StringReader(output));
            String line = null;
            String regexString = this.autoGenerateName.equals("ID") ? "^\\(([0-9]+)\\)" : "\"([^\"]*)\"";
            Pattern patt = Pattern.compile(regexString);
            while ((line = read.readLine()) != null) {
                Matcher match = patt.matcher(line);
                if (!match.find()) continue;
                result = match.group(1);
                break;
            }
            IO.close(read);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            IOException finExc = new IOException();
            finExc.initCause(e);
            throw finExc;
        }
        finally {
            proc.destroy();
        }
        return result;
    }

    private void runCommand(List<String> command) throws IOException {
        StringBuilder logMess = new StringBuilder();
        logMess.append("Running command:");
        for (String elem : command) {
            logMess.append(" ");
            logMess.append(elem);
        }
        log.info((Object)logMess.toString());
        ProcessBuilder builder = new ProcessBuilder(command);
        Processes processes = new Processes();
        Process proc = builder.start();
        try {
            IO.close(proc.getOutputStream());
            WaitFuture outFut = processes.redirectOutput(proc, System.out);
            WaitFuture errFut = processes.redirectError(proc, System.out);
            int status = proc.waitFor();
            outFut.get();
            errFut.get();
            if (status != 0) {
                throw new IOException("Error running command");
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            IOException finExc = new IOException();
            finExc.initCause(e);
            throw finExc;
        }
        finally {
            proc.destroy();
        }
    }
}

