/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.vfs.common;

import com.urbancode.vfs.common.ClientObject;
import com.urbancode.vfs.common.ClientPathEntry;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientChangeSetDelta
implements ClientObject {
    private final String repositoryId;
    private final List<ClientPathEntry> clientPathEntries;

    public ClientChangeSetDelta(String repositoryId, List<ClientPathEntry> entries) {
        this.repositoryId = repositoryId;
        this.clientPathEntries = new ArrayList<ClientPathEntry>();
        this.clientPathEntries.addAll(entries);
    }

    public void removeEntry(ClientPathEntry entry) {
        this.clientPathEntries.remove(entry);
    }

    public ClientPathEntry[] getEntries() {
        return this.clientPathEntries.toArray(new ClientPathEntry[0]);
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("repoId", this.getRepositoryId());
        JSONArray entryArray = new JSONArray();
        for (ClientPathEntry entry : this.getEntries()) {
            JSONObject jsonEntry = entry.toJSON();
            entryArray.put(jsonEntry);
        }
        json.put("entries", entryArray);
        return json;
    }
}

