/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appcenter;

import com.ibm.appcenter.ant.ImpRestServices;
import com.ibm.appcenter.ant.PublishException;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;

public class Upload {
    private static boolean showExceptionStackTrace = false;
    private static boolean showHelp = false;
    private static boolean deleteApps = false;

    public static void main(String[] args) {
        ImpRestServices irs = new ImpRestServices();
        irs.setForceOverwrite(false);
        String user = "appcenteradmin";
        String password = "";
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < args.length; ++i) {
            if ("-s".equalsIgnoreCase(args[i]) || "-server".equalsIgnoreCase(args[i]) || "-serverpath".equalsIgnoreCase(args[i])) {
                if (++i >= args.length) break;
                if (args[i].endsWith("/")) {
                    irs.setServerRoot(args[i]);
                    continue;
                }
                irs.setServerRoot(args[i] + "/");
                continue;
            }
            if ("-c".equalsIgnoreCase(args[i]) || "-context".equalsIgnoreCase(args[i])) {
                if (++i >= args.length) break;
                irs.setContext(args[i]);
                continue;
            }
            if ("-u".equalsIgnoreCase(args[i]) || "-user".equalsIgnoreCase(args[i]) || "-loginuser".equalsIgnoreCase(args[i])) {
                if (++i >= args.length) break;
                user = args[i];
                irs.setAuthentication(user, password);
                continue;
            }
            if ("-p".equalsIgnoreCase(args[i]) || "-password".equalsIgnoreCase(args[i]) || "-loginpass".equalsIgnoreCase(args[i])) {
                if (++i >= args.length) break;
                password = args[i];
                irs.setAuthentication(user, password);
                continue;
            }
            if ("-d".equalsIgnoreCase(args[i]) || "-description".equalsIgnoreCase(args[i])) {
                if (++i >= args.length) break;
                irs.setDescription(args[i]);
                continue;
            }
            if ("-l".equalsIgnoreCase(args[i]) || "-fallbacklabel".equalsIgnoreCase(args[i]) || "-label".equalsIgnoreCase(args[i])) {
                if (++i >= args.length) break;
                irs.setFallbackLabel(args[i]);
                continue;
            }
            if ("-isrecommended".equalsIgnoreCase(args[i])) {
                if (++i >= args.length) break;
                irs.setIsRecommended(args[i]);
                continue;
            }
            if ("-isinstaller".equalsIgnoreCase(args[i])) {
                if (++i >= args.length) break;
                irs.setIsInstaller(args[i]);
                continue;
            }
            if ("-isreadyforproduction".equalsIgnoreCase(args[i])) {
                if (++i >= args.length) break;
                irs.setIsReadyForProduction(args[i]);
                continue;
            }
            if ("-isactive".equalsIgnoreCase(args[i])) {
                if (++i >= args.length) break;
                irs.setIsActive(args[i]);
                continue;
            }
            if ("-f".equalsIgnoreCase(args[i]) || "-force".equalsIgnoreCase(args[i]) || "-forceoverwrite".equalsIgnoreCase(args[i])) {
                irs.setForceOverwrite(true);
                continue;
            }
            if ("-delete".equalsIgnoreCase(args[i])) {
                deleteApps = true;
                continue;
            }
            if ("-h".equalsIgnoreCase(args[i])) {
                showHelp = true;
                continue;
            }
            if ("-e".equalsIgnoreCase(args[i]) || "-showException".equalsIgnoreCase(args[i])) {
                showExceptionStackTrace = true;
                continue;
            }
            if ("-y".equalsIgnoreCase(args[i]) || "-disableSSLSecurity".equalsIgnoreCase(args[i])) {
                irs.setDisableSSLSecurity(true);
                continue;
            }
            File f = new File(args[i]);
            files.add(f);
        }
        ResourceBundle bundle = ResourceBundle.getBundle("com.ibm.appcenter.upload", Locale.getDefault());
        if (files.size() == 0 || showHelp) {
            String usage = MessageFormat.format(bundle.getString("Upload.usage"), Upload.class.getName());
            System.out.println(usage);
        } else {
            irs.setExceptionOnNotFoundOnDelete(true);
            for (File f : files) {
                if (!f.exists()) {
                    if (deleteApps) {
                        String spec = f.getName();
                        String[] parts = spec.split("@");
                        if (parts.length >= 3) {
                            irs.delete(parts[0], parts[1], parts[2]);
                            continue;
                        }
                        if (parts.length >= 2) {
                            irs.delete(parts[0], parts[1]);
                            continue;
                        }
                        irs.delete(spec);
                        continue;
                    }
                    String msg = MessageFormat.format(bundle.getString("Upload.fileNotFound"), f.getAbsolutePath());
                    System.out.println(msg);
                    continue;
                }
                try {
                    if (deleteApps) {
                        irs.delete(f);
                        continue;
                    }
                    irs.publish(f);
                }
                catch (PublishException ex) {
                    System.out.println(ex.getMessage());
                    if (!showExceptionStackTrace) continue;
                    ex.printStackTrace();
                }
            }
        }
    }
}

