/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.io;

import com.urbancode.commons.io.StreamBuffer;
import java.io.IOException;
import java.io.OutputStream;

public class BufferOutputStream
extends OutputStream {
    private StreamBuffer buffer = null;
    private boolean isClosed = false;

    public BufferOutputStream(StreamBuffer buffer) {
        this.buffer = buffer;
        buffer.addFeeder(this);
    }

    public synchronized void close() throws IOException {
        this.isClosed = true;
        this.buffer.removeFeeder(this);
    }

    public synchronized void write(byte[] data, int offset, int len) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream is closed");
        }
        this.buffer.write(data, offset, len);
    }

    public synchronized void write(int b) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream is closed");
        }
        this.buffer.write(b);
    }
}

