--
-- Licensed Materials - Property of IBM
-- 5725-G92 (C) Copyright IBM Corp. 2011, 2013. All Rights Reserved.
-- US Government Users Restricted Rights - Use, duplication or
-- disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
--

CREATE TABLE ADAPTER_SYNC_DATA (ID BIGINT NOT NULL AUTO_INCREMENT, deployable LONGBLOB NOT NULL, deployableHash VARCHAR(255) NOT NULL, deployableKey VARCHAR(255) NOT NULL, PRIMARY KEY (ID), UNIQUE UNQ_deployableKey (deployableKey)) ENGINE = innodb;
CREATE TABLE APP_SYNC_DATA (ID BIGINT NOT NULL AUTO_INCREMENT, appDeployableKey VARCHAR(255) NOT NULL, deployable LONGBLOB NOT NULL, deployableHash VARCHAR(255) NOT NULL, lastPersistentPropertyChange BIGINT NOT NULL, PRIMARY KEY (ID), UNIQUE UNQ_appDeployableKey (appDeployableKey)) ENGINE = innodb;
CREATE TABLE APP_VERSION_ACCESS_DATA (ID BIGINT NOT NULL AUTO_INCREMENT, ACTION VARCHAR(255) NOT NULL, CREATED_TIME DATETIME NOT NULL, DOWNLOAD_LINK VARCHAR(255), ENV VARCHAR(255) NOT NULL, GADGET_NAME VARCHAR(255) NOT NULL, MESSAGE VARCHAR(255) NOT NULL, VERSION VARCHAR(255) NOT NULL, MULTILANGUAGE_MESSAGES TEXT, PRIMARY KEY (ID), UNIQUE UNQ_GADGET_NAMENVVERSION (GADGET_NAME, ENV, VERSION)) ENGINE = innodb;
CREATE TABLE AUTH_ASSOCIATED_IDENTITY (fromLoginModule VARCHAR(255) NOT NULL, fromUserId VARCHAR(255) NOT NULL, toLoginModule VARCHAR(255) NOT NULL, lastAccess BIGINT, toIdentityStr LONGTEXT, toUserId VARCHAR(255), PRIMARY KEY (fromLoginModule, fromUserId, toLoginModule)) ENGINE = innodb;
CREATE TABLE CLUSTER_SYNC (ID VARCHAR(255) NOT NULL, hostVmId VARCHAR(255), updateTimestamp BIGINT, version BIGINT NOT NULL, PRIMARY KEY (ID)) ENGINE = innodb;
CREATE TABLE GADGETS (ID BIGINT NOT NULL AUTO_INCREMENT, DISP_IN_GALLERY BIT, LAST_UPDATE_TIME DATETIME NOT NULL, NAME VARCHAR(255) NOT NULL, PRIMARY KEY (ID), UNIQUE UNQ_ (NAME)) ENGINE = innodb;
CREATE TABLE GADGET_APPLICATIONS (ID BIGINT NOT NULL AUTO_INCREMENT, ENFORCE_AUTHENTICITY BIT, ENVIRONMENT_ID VARCHAR(255) NOT NULL, SERVER_VERSION VARCHAR(255) NOT NULL, VERSION VARCHAR(255) NOT NULL, VERSION_LOCKED BIT, GADGET_ID BIGINT NOT NULL, PRIMARY KEY (ID)) ENGINE = innodb;
CREATE TABLE GADGET_USER (GADGET_APP_ID VARCHAR(255) NOT NULL, USER_ID VARCHAR(255) NOT NULL, FIRST_ACCESS_TIME DATE NOT NULL, GADGET_ID VARCHAR(255) NOT NULL, PRIMARY KEY (GADGET_APP_ID, USER_ID)) ENGINE = innodb;
CREATE TABLE GADGET_USER_PREF (ID BIGINT NOT NULL AUTO_INCREMENT, GADGET_APP_ID VARCHAR(255) NOT NULL, NAME VARCHAR(255) NOT NULL, USER_ID VARCHAR(255), VALUE LONGTEXT, PRIMARY KEY (ID)) ENGINE = innodb;
CREATE TABLE NOTIFICATION_APPLICATION (applicationId VARCHAR(255) NOT NULL, MEDIATORTYPE SMALLINT NOT NULL, platformStr VARCHAR(255) NOT NULL, dataStr LONGTEXT, ENABLED BIT, PRIMARY KEY (applicationId, MEDIATORTYPE, platformStr)) ENGINE = innodb;
CREATE TABLE NOTIFICATION_DEVICE (ID BIGINT NOT NULL AUTO_INCREMENT, alias VARCHAR(255), applicationId VARCHAR(255) NOT NULL, device VARCHAR(255) NOT NULL, options VARCHAR(255), platform VARCHAR(255) NOT NULL, token VARCHAR(255) NOT NULL, userAgent VARCHAR(255) NOT NULL, userSubscriptionId BIGINT NOT NULL, PRIMARY KEY (ID)) ENGINE = innodb;
CREATE TABLE NOTIFICATION_MEDIATOR (mediatorStr VARCHAR(255) NOT NULL, stateStr LONGTEXT, PRIMARY KEY (mediatorStr)) ENGINE = innodb;
CREATE TABLE NOTIFICATION_USER (ID BIGINT NOT NULL AUTO_INCREMENT, eventSource VARCHAR(255) NOT NULL, state LONGTEXT, userId VARCHAR(255) NOT NULL, PRIMARY KEY (ID), UNIQUE UNQ_USERIDEVENTSOURCE (userId, eventSource)) ENGINE = innodb;
CREATE TABLE OPENJPA_SEQUENCE_TABLE (ID TINYINT NOT NULL, SEQUENCE_VALUE BIGINT, PRIMARY KEY (ID)) ENGINE = innodb;
CREATE TABLE PROPERTIES (property VARCHAR(255) NOT NULL, value VARCHAR(255), PRIMARY KEY (property)) ENGINE = innodb;
CREATE TABLE SSO_LOGIN_CONTEXTS (DEVICE_ID VARCHAR(255) NOT NULL, DEVICE_LOGIN_MODULE VARCHAR(255) NOT NULL, SSO_LOGIN_MODULE VARCHAR(255) NOT NULL, LOGIN_CONTEXT LONGBLOB NOT NULL, EXPIRES DATETIME NOT NULL, PRIMARY KEY (DEVICE_ID, DEVICE_LOGIN_MODULE, SSO_LOGIN_MODULE)) ENGINE = innodb;
CREATE TABLE USAGE_DATA (TIME_AT_BEGINING_OF_DAY BIGINT NOT NULL, USER_ID VARCHAR(255) NOT NULL, EXACT_LOGIN_TIME BIGINT, PRIMARY KEY (TIME_AT_BEGINING_OF_DAY, USER_ID)) ENGINE = innodb;
CREATE TABLE WORKLIGHT_VERSION (WORKLIGHT_VERSION VARCHAR(50) NOT NULL) ENGINE = innodb;
INSERT INTO WORKLIGHT_VERSION(WORKLIGHT_VERSION) SELECT '0.0.0.initial' FROM DUAL WHERE NOT EXISTS (SELECT * FROM WORKLIGHT_VERSION);
CREATE INDEX I_GDGTTNS_GADGET ON GADGET_APPLICATIONS (GADGET_ID);
CREATE INDEX I_NTFCDVC_PARENT ON NOTIFICATION_DEVICE (userSubscriptionId);
CREATE INDEX I_NTFCDVC_DEVICE ON NOTIFICATION_DEVICE (DEVICE);

