/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Deploy
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2015. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool;
import com.ibm.rational.air.plugin.worklight.Util;

def apTool = new AirPluginTool(this.args[0], this.args[1]);
final def props = apTool.getStepProperties();

def serverpath = props['serverpath']
def runtime = props['runtime']
def wlappName = props['wlappName']
def env = props['env']
def version = props['version']
def ruleFile = props['ruleFile']
def worklightAntJar = props['worklightAntJar']
def user = props['user']
def password = props['password']
boolean secure = Boolean.parseBoolean(props['secure']?: "true")

try {
    println "Changing application access rules with the following properties:"
    println "Server Path: ${serverpath}"
    println "Application: ${wlappName}"
    println "Environment: ${env}"
    println "Version: ${version}"
    println "Rule File: ${ruleFile}"
    println "Worklight Ant Deployer JAR Path: ${worklightAntJar}"

    File worklightAntJarFile = new File(worklightAntJar)
    if(!worklightAntJarFile.exists() || !worklightAntJarFile.isFile() || 
        !Util.isWorklightDeployerAntJar(worklightAntJarFile)) {
        println "Error: The path to the Worklight Ant Deployer JAR file is invalid: " +
                "${worklightAntJarFile.getCanonicalPath()}. Change the value of the " +
                "Worklight Ant JAR File Path attribute to the path to the Worklight " +
                "Ant Deployer JAR file. For example, use " +
                "/opt/IBM/Worklight/WorklightServer/worklight-ant-deployer.jar."
        System.exit(-1)
    }
	
    def serverVersion = Util.determineServerVersion(worklightAntJarFile, serverpath, user,
        password, secure);
    if ( serverVersion == Util.WL_SERVER_62  ||
         serverVersion == Util.WL_SERVER_63  ||
         serverVersion == Util.WL_SERVER_70  ||
         serverVersion == Util.WL_SERVER_71
		 ) {
        def ant = Util.getWLADMAnt(worklightAntJarFile);
        ant.wladm ( url:serverpath, user:user, password:password, secure:secure) {
            'app-version' ( name:wlappName, environment:env, version:version, 
                runtime:runtime ) {
                'set-accessrule' ( file:ruleFile )
            }
        }
    } else {
        if(serverVersion) {
            println "Error: The Worklight Server version is not supported by this step.";
        } else {
            println "Error: The Worklight Server version could not be determined or there " +
                "is a mismatch between the Worklight Ant Deployer JAR and the server.";
            println "Explanation: This error can occur if the Worklight Server Path specified " +
                "in the Server Path attribute is not correct or the path to the Worklight Ant " +
                "Deployer JAR specified in the Worklight Ant JAR File Path attribute is not " +
                "correct.";
            println "User response: Verify the path specified by the Server Path attribute is " +
                "correct. For example, use http://localhost:9080/worklight on Worklight " +
                "6.0 or 6.1 Servers, or https://localhost:9443/worklightadmin on Worklight " +
                "6.2 Servers. Verify the JAR file specified in the Worklight Ant JAR File " +
                "Path attribute uses the JAR from the corresponding Worklight Server. For " +
                "example, use /opt/IBM/Worklight/WorklightServer/worklight-ant-deployer.jar.";
        }
        System.exit(-1)
    }
} catch (Exception e) {
    println "An error occurred while changing the application access rules: ${e.message}"
    System.exit(-1)
}

println "The Change Application Access Rule on Worklight Server step completed successfully."
System.exit(0)