--
-- Licensed Materials - Property of IBM
-- 5725-G92 (C) Copyright IBM Corp. 2011, 2013. All Rights Reserved.
-- US Government Users Restricted Rights - Use, duplication or
-- disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
--

SELECT SEQSCHEMA AS SEQUENCE_SCHEMA, SEQNAME AS SEQUENCE_NAME FROM SYSCAT.SEQUENCES;
CREATE TABLE ACTIVITIES_CUBE (AID BIGINT NOT NULL, ACTIVITY_DATE DATE, APP_NAME VARCHAR(254), APP_VERSION VARCHAR(254), DEVICE_ID VARCHAR(254), ENVIRONMENT VARCHAR(254), TOTAL_ACTIVITY BIGINT, PRIMARY KEY (AID));
CREATE TABLE APP_ACTIVITY_REPORT (ID BIGINT NOT NULL, ACTIVITY CLOB(1M), ACTIVITY_TIMESTAMP TIMESTAMP, ADAPTER VARCHAR(254), DEVICE_ID VARCHAR(254), DEVICE_MODEL VARCHAR(254), DEVICE_OS VARCHAR(254), ENVIRONMENT VARCHAR(254), GADGET_NAME VARCHAR(254), GADGET_VERSION VARCHAR(254), IP_ADDRESS VARCHAR(254), PROC VARCHAR(254), SESSION_ID VARCHAR(254), SOURCE VARCHAR(254), USER_AGENT VARCHAR(254), LONGITUDE DOUBLE, LATITUDE DOUBLE, POS_USER_TIME TIMESTAMP(3), WIFI_APS VARCHAR(4000), WIFI_CONNECTED_SSID VARCHAR(32), WIFI_CONNECTED_MAC CHAR(20), WIFI_USER_TIME TIMESTAMP(3), APP_CONTEXT VARCHAR(4000), PRIMARY KEY (ID));
CREATE TABLE FACT_ACTIVITIES (AID VARCHAR(254) NOT NULL, ACTIVITY_DATE DATE, APP_NAME VARCHAR(254), APP_VERSION VARCHAR(254), DEVICE_ID VARCHAR(254), DEVICE_MODEL VARCHAR(254), DEVICE_OS VARCHAR(254), ENVIRONMENT VARCHAR(254), TOTAL_ACTIVITY INTEGER, PRIMARY KEY (AID));
CREATE TABLE OPENJPA_SEQUENCE_TABLE (ID SMALLINT NOT NULL, SEQUENCE_VALUE BIGINT, PRIMARY KEY (ID));
CREATE TABLE PROC_REPORT (ID INTEGER NOT NULL, NUM_PROCESSED INTEGER, PROC_TIMESTAMP TIMESTAMP, PRIMARY KEY (ID));
CREATE TABLE NOTIFICATION_REPORT (ID BIGINT NOT NULL, APP_NAME VARCHAR(254), DESTINATION_NUMBER VARCHAR(254), EVENT_SOURCE VARCHAR(254), MEDIATOR VARCHAR(254), MESSAGE_COUNT INTEGER, NOTIFICATION_TIMESTAMP TIMESTAMP, SENDER_ID VARCHAR(254), SUBSCRIPTION_PROPERTIES VARCHAR(254), PRIMARY KEY (ID));
CREATE TABLE NOTIFICATION_ACTIVITIES (SID VARCHAR(254) NOT NULL, EVENT_SOURCE VARCHAR(254), MEDIATOR VARCHAR(254), NOTIFICATION_DATE DATE, TOTAL_NOTIFICATIONS INTEGER, PRIMARY KEY (SID));
CREATE TABLE NOTIFICATION_PROC_REPORT (ID INTEGER NOT NULL, NUM_PROCESSED INTEGER, PROC_TIMESTAMP TIMESTAMP, PRIMARY KEY (ID));
CREATE TABLE WORKLIGHT_VERSION (WORKLIGHT_VERSION VARCHAR(50) NOT NULL);
INSERT INTO WORKLIGHT_VERSION(WORKLIGHT_VERSION) SELECT '0.0.0.initial' FROM SYSIBM.SYSDUMMY1 WHERE NOT EXISTS (SELECT * FROM WORKLIGHT_VERSION);
